/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Explanation;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchTargetModel;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeBiFunctionProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeFunctionProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeListProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeProjectionBuilder;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeTriFunctionProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDocumentProjectionBuilder;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDocumentReferenceProjectionBuilder;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneExplanationProjectionBuilder;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneObjectProjectionBuilder;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneReferenceProjectionBuilder;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneScoreProjectionBuilder;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.DocumentReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ObjectProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ScoreProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.function.TriFunction;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class LuceneSearchProjectionBuilderFactory
implements SearchProjectionBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ProjectionBuilderFactoryRetrievalStrategy PROJECTION_BUILDER_FACTORY_RETRIEVAL_STRATEGY = new ProjectionBuilderFactoryRetrievalStrategy();
    private final LuceneSearchTargetModel searchTargetModel;

    public LuceneSearchProjectionBuilderFactory(LuceneSearchTargetModel searchTargetModel) {
        this.searchTargetModel = searchTargetModel;
    }

    public DocumentReferenceProjectionBuilder documentReference() {
        return LuceneDocumentReferenceProjectionBuilder.get();
    }

    public <T> FieldProjectionBuilder<T> field(String absoluteFieldPath, Class<T> expectedType) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PROJECTION_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createFieldValueProjectionBuilder(absoluteFieldPath, expectedType);
    }

    public <O> ObjectProjectionBuilder<O> object() {
        return LuceneObjectProjectionBuilder.get();
    }

    public <R> ReferenceProjectionBuilder<R> reference() {
        return LuceneReferenceProjectionBuilder.get();
    }

    public ScoreProjectionBuilder score() {
        return LuceneScoreProjectionBuilder.get();
    }

    public DistanceToFieldProjectionBuilder distance(String absoluteFieldPath, GeoPoint center) {
        return this.searchTargetModel.getSchemaNodeComponent(absoluteFieldPath, PROJECTION_BUILDER_FACTORY_RETRIEVAL_STRATEGY).createDistanceProjectionBuilder(absoluteFieldPath, center);
    }

    public <T> CompositeProjectionBuilder<T> composite(Function<List<?>, T> transformer, SearchProjection<?> ... projections) {
        ArrayList typedProjections = new ArrayList(projections.length);
        for (SearchProjection<?> projection : projections) {
            typedProjections.add(this.toImplementation(projection));
        }
        return new LuceneCompositeProjectionBuilder(new LuceneCompositeListProjection<T>(transformer, typedProjections));
    }

    public <P, T> CompositeProjectionBuilder<T> composite(Function<P, T> transformer, SearchProjection<P> projection) {
        return new LuceneCompositeProjectionBuilder(new LuceneCompositeFunctionProjection(transformer, this.toImplementation(projection)));
    }

    public <P1, P2, T> CompositeProjectionBuilder<T> composite(BiFunction<P1, P2, T> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2) {
        return new LuceneCompositeProjectionBuilder(new LuceneCompositeBiFunctionProjection<P1, P2, T>(transformer, this.toImplementation(projection1), this.toImplementation(projection2)));
    }

    public <P1, P2, P3, T> CompositeProjectionBuilder<T> composite(TriFunction<P1, P2, P3, T> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2, SearchProjection<P3> projection3) {
        return new LuceneCompositeProjectionBuilder(new LuceneCompositeTriFunctionProjection<P1, P2, P3, T>(transformer, this.toImplementation(projection1), this.toImplementation(projection2), this.toImplementation(projection3)));
    }

    public <T> LuceneSearchProjection<?, T> toImplementation(SearchProjection<T> projection) {
        if (!(projection instanceof LuceneSearchProjection)) {
            throw log.cannotMixLuceneSearchQueryWithOtherProjections(projection);
        }
        return (LuceneSearchProjection)projection;
    }

    public SearchProjectionBuilder<Document> document() {
        return LuceneDocumentProjectionBuilder.get();
    }

    public SearchProjectionBuilder<Explanation> explanation() {
        return LuceneExplanationProjectionBuilder.get();
    }

    private static class ProjectionBuilderFactoryRetrievalStrategy
    implements IndexSchemaFieldNodeComponentRetrievalStrategy<LuceneFieldProjectionBuilderFactory> {
        private ProjectionBuilderFactoryRetrievalStrategy() {
        }

        @Override
        public LuceneFieldProjectionBuilderFactory extractComponent(LuceneIndexSchemaFieldNode<?> schemaNode) {
            return schemaNode.getProjectionBuilderFactory();
        }

        @Override
        public boolean areCompatible(LuceneFieldProjectionBuilderFactory component1, LuceneFieldProjectionBuilderFactory component2) {
            return component1.isDslCompatibleWith(component2);
        }

        @Override
        public SearchException createCompatibilityException(String absoluteFieldPath, LuceneFieldProjectionBuilderFactory component1, LuceneFieldProjectionBuilderFactory component2, EventContext context) {
            return log.conflictingFieldTypesForProjection(absoluteFieldPath, component1, component2, context);
        }
    }
}

