/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class SearchProjectionExtractContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexSearcher indexSearcher;
    private final Query luceneQuery;

    public SearchProjectionExtractContext(IndexSearcher indexSearcher, Query luceneQuery) {
        this.indexSearcher = indexSearcher;
        this.luceneQuery = luceneQuery;
    }

    public Explanation explain(int docId) {
        try {
            return this.indexSearcher.explain(this.luceneQuery, docId);
        }
        catch (IOException e) {
            throw log.ioExceptionOnExplain(e);
        }
    }
}

