/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.backend.lucene.index.spi.ReaderProvider;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneQueryWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorProvider;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultExtractor;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.LuceneExecuteQueryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.SearchQuery;
import org.hibernate.search.engine.search.SearchResult;

public class LuceneSearchQuery<T>
implements SearchQuery<T> {
    private final LuceneQueryWorkOrchestrator queryOrchestrator;
    private final LuceneWorkFactory workFactory;
    private final Set<String> indexNames;
    private final Set<ReaderProvider> readerProviders;
    private final SessionContextImplementor sessionContext;
    private final Query luceneQuery;
    private final Sort luceneSort;
    private final LuceneCollectorProvider luceneCollectorProvider;
    private final LuceneSearchResultExtractor<T> searchResultExtractor;
    private Long firstResultIndex = 0L;
    private Long maxResultsCount;

    public LuceneSearchQuery(LuceneQueryWorkOrchestrator queryOrchestrator, LuceneWorkFactory workFactory, Set<String> indexNames, Set<ReaderProvider> readerProviders, SessionContextImplementor sessionContext, Query luceneQuery, Sort luceneSort, LuceneCollectorProvider luceneCollectorProvider, LuceneSearchResultExtractor<T> searchResultExtractor) {
        this.queryOrchestrator = queryOrchestrator;
        this.workFactory = workFactory;
        this.indexNames = indexNames;
        this.readerProviders = readerProviders;
        this.sessionContext = sessionContext;
        this.luceneQuery = luceneQuery;
        this.luceneSort = luceneSort;
        this.luceneCollectorProvider = luceneCollectorProvider;
        this.searchResultExtractor = searchResultExtractor;
    }

    public void setFirstResult(Long firstResultIndex) {
        this.firstResultIndex = firstResultIndex;
    }

    public void setMaxResults(Long maxResultsCount) {
        this.maxResultsCount = maxResultsCount;
    }

    public String getQueryString() {
        return this.luceneQuery.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[query=" + this.getQueryString() + ", sort=" + this.luceneSort + "]";
    }

    public SearchResult<T> execute() {
        LuceneExecuteQueryWork<T> work = this.workFactory.search(new LuceneSearcher<T>(this.indexNames, this.readerProviders, this.luceneQuery, this.luceneSort, this.firstResultIndex, this.maxResultsCount, this.luceneCollectorProvider, this.searchResultExtractor));
        return ((LuceneLoadableSearchResult)this.queryOrchestrator.submit(work).join()).loadBlocking(this.sessionContext);
    }

    public long executeCount() {
        LuceneExecuteQueryWork<T> work = this.workFactory.search(new LuceneSearcher<T>(this.indexNames, this.readerProviders, this.luceneQuery, this.luceneSort, 0L, 0L, luceneCollectorBuilder -> {}, this.searchResultExtractor));
        return ((LuceneLoadableSearchResult)this.queryOrchestrator.submit(work).join()).getHitCount();
    }
}

