/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.util.function.Function;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneQueryWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.extraction.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.backend.lucene.search.impl.LuceneQueries;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchTargetModel;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultExtractorImpl;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.SearchQuery;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

class LuceneSearchQueryBuilder<T>
implements SearchQueryBuilder<T, LuceneSearchQueryElementCollector> {
    private final LuceneWorkFactory workFactory;
    private final LuceneQueryWorkOrchestrator queryOrchestrator;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final LuceneSearchTargetModel searchTargetModel;
    private final SessionContextImplementor sessionContext;
    private final ReusableDocumentStoredFieldVisitor storedFieldVisitor;
    private final ProjectionHitMapper<?, ?> projectionHitMapper;
    private final LuceneSearchProjection<?, T> rootProjection;
    private final LuceneSearchQueryElementCollector elementCollector;

    LuceneSearchQueryBuilder(LuceneWorkFactory workFactory, LuceneQueryWorkOrchestrator queryOrchestrator, MultiTenancyStrategy multiTenancyStrategy, LuceneSearchTargetModel searchTargetModel, SessionContextImplementor sessionContext, ReusableDocumentStoredFieldVisitor storedFieldVisitor, ProjectionHitMapper<?, ?> projectionHitMapper, LuceneSearchProjection<?, T> rootProjection) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.searchTargetModel = searchTargetModel;
        this.sessionContext = sessionContext;
        this.elementCollector = new LuceneSearchQueryElementCollector();
        this.storedFieldVisitor = storedFieldVisitor;
        this.projectionHitMapper = projectionHitMapper;
        this.rootProjection = rootProjection;
    }

    public LuceneSearchQueryElementCollector getQueryElementCollector() {
        return this.elementCollector;
    }

    public void addRoutingKey(String routingKey) {
        throw new UnsupportedOperationException("Routing keys are not supported by the Lucene backend yet.");
    }

    private SearchQuery<T> build() {
        LuceneSearchResultExtractorImpl<T> searchResultExtractor = new LuceneSearchResultExtractorImpl<T>(this.storedFieldVisitor, this.rootProjection, this.projectionHitMapper);
        BooleanQuery.Builder luceneQueryBuilder = new BooleanQuery.Builder();
        luceneQueryBuilder.add(this.elementCollector.toLuceneQueryPredicate(), BooleanClause.Occur.MUST);
        luceneQueryBuilder.add(LuceneQueries.mainDocumentQuery(), BooleanClause.Occur.FILTER);
        return new LuceneSearchQuery<T>(this.queryOrchestrator, this.workFactory, this.searchTargetModel.getIndexNames(), this.searchTargetModel.getReaderProviders(), this.sessionContext, this.multiTenancyStrategy.decorateLuceneQuery((Query)luceneQueryBuilder.build(), this.sessionContext.getTenantIdentifier()), this.elementCollector.toLuceneSort(), this.rootProjection, searchResultExtractor);
    }

    public <Q> Q build(Function<SearchQuery<T>, Q> searchQueryWrapperFactory) {
        return searchQueryWrapperFactory.apply(this.build());
    }
}

