/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchTargetModel;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilderFactoryImpl;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.search.dsl.spi.SearchTargetContext;

public class LuceneSearchTargetContext
implements SearchTargetContext<LuceneSearchQueryElementCollector> {
    private final LuceneSearchTargetModel searchTargetModel;
    private final LuceneSearchPredicateBuilderFactoryImpl searchPredicateFactory;
    private final LuceneSearchSortBuilderFactoryImpl searchSortFactory;
    private final LuceneSearchQueryBuilderFactory searchQueryFactory;
    private final LuceneSearchProjectionBuilderFactory searchProjectionFactory;

    public LuceneSearchTargetContext(SearchBackendContext searchBackendContext, MappingContextImplementor mappingContext, LuceneSearchTargetModel searchTargetModel) {
        LuceneSearchContext searchContext = new LuceneSearchContext(mappingContext);
        this.searchTargetModel = searchTargetModel;
        this.searchPredicateFactory = new LuceneSearchPredicateBuilderFactoryImpl(searchContext, searchTargetModel);
        this.searchSortFactory = new LuceneSearchSortBuilderFactoryImpl(searchContext, searchTargetModel);
        this.searchProjectionFactory = new LuceneSearchProjectionBuilderFactory(searchTargetModel);
        this.searchQueryFactory = new LuceneSearchQueryBuilderFactory(searchBackendContext, searchTargetModel, this.searchProjectionFactory);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexNames=" + this.searchTargetModel.getIndexNames() + "]";
    }

    public LuceneSearchPredicateBuilderFactoryImpl getSearchPredicateBuilderFactory() {
        return this.searchPredicateFactory;
    }

    public LuceneSearchSortBuilderFactoryImpl getSearchSortBuilderFactory() {
        return this.searchSortFactory;
    }

    public LuceneSearchQueryBuilderFactory getSearchQueryBuilderFactory() {
        return this.searchQueryFactory;
    }

    public LuceneSearchProjectionBuilderFactory getSearchProjectionFactory() {
        return this.searchProjectionFactory;
    }
}

