/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.time.Instant;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericFieldCodec;

public final class LuceneInstantFieldCodec
implements LuceneNumericFieldCodec<Instant, Long> {
    private final boolean projectable;
    private final boolean sortable;

    public LuceneInstantFieldCodec(boolean projectable, boolean sortable) {
        this.projectable = projectable;
        this.sortable = sortable;
    }

    @Override
    public void encode(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Instant value) {
        if (value == null) {
            return;
        }
        long time = this.encode(value);
        if (this.projectable) {
            documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, time));
        }
        if (this.sortable) {
            documentBuilder.addField((IndexableField)new NumericDocValuesField(absoluteFieldPath, time));
        }
        documentBuilder.addField((IndexableField)new LongPoint(absoluteFieldPath, new long[]{time}));
    }

    @Override
    public Instant decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        Long time = (Long)field.numericValue();
        return Instant.ofEpochMilli(time);
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (LuceneInstantFieldCodec.class != obj.getClass()) {
            return false;
        }
        LuceneInstantFieldCodec other = (LuceneInstantFieldCodec)obj;
        return this.projectable == other.projectable && this.sortable == other.sortable;
    }

    @Override
    public Long encode(Instant value) {
        return value == null ? null : Long.valueOf(value.toEpochMilli());
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneNumericDomain.LONG;
    }
}

