/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

public abstract class LuceneNumericDomain<E> {
    public static final LuceneNumericDomain<Integer> INTEGER = new LuceneNumericDomain<Integer>(){

        @Override
        public Integer getMinValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Integer getMaxValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Integer getPreviousValue(Integer value) {
            return Math.addExact(value, -1);
        }

        @Override
        public Integer getNextValue(Integer value) {
            return Math.addExact(value, 1);
        }

        @Override
        public Query createExactQuery(String absoluteFieldPath, Integer value) {
            return IntPoint.newExactQuery((String)absoluteFieldPath, (int)value);
        }

        @Override
        public Query createRangeQuery(String absoluteFieldPath, Integer lowerLimit, Integer upperLimit) {
            return IntPoint.newRangeQuery((String)absoluteFieldPath, (int)lowerLimit, (int)upperLimit);
        }

        @Override
        public SortField.Type getSortFieldType() {
            return SortField.Type.INT;
        }
    };
    public static final LuceneNumericDomain<Long> LONG = new LuceneNumericDomain<Long>(){

        @Override
        public Long getMinValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public Long getMaxValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public Long getPreviousValue(Long value) {
            return Math.addExact(value, -1L);
        }

        @Override
        public Long getNextValue(Long value) {
            return Math.addExact(value, 1L);
        }

        @Override
        public Query createExactQuery(String absoluteFieldPath, Long value) {
            return LongPoint.newExactQuery((String)absoluteFieldPath, (long)value);
        }

        @Override
        public Query createRangeQuery(String absoluteFieldPath, Long lowerLimit, Long upperLimit) {
            return LongPoint.newRangeQuery((String)absoluteFieldPath, (long)lowerLimit, (long)upperLimit);
        }

        @Override
        public SortField.Type getSortFieldType() {
            return SortField.Type.LONG;
        }
    };

    public abstract E getMinValue();

    public abstract E getMaxValue();

    public abstract E getPreviousValue(E var1);

    public abstract E getNextValue(E var1);

    public abstract Query createExactQuery(String var1, E var2);

    public abstract Query createRangeQuery(String var1, E var2, E var3);

    public abstract SortField.Type getSortFieldType();
}

