/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.LocalDate;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldContributor;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldValueExtractor;
import org.hibernate.search.backend.lucene.types.dsl.LuceneIndexFieldTypeFactoryContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneBooleanIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneFieldIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneGeoPointIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneInstantIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIntegerIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneLocalDateIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneLongIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneStringIndexFieldTypeContext;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeTerminalContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeContext;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class LuceneIndexFieldTypeFactoryContextImpl
implements LuceneIndexFieldTypeFactoryContext,
LuceneIndexFieldTypeBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext eventContext;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;

    public LuceneIndexFieldTypeFactoryContextImpl(EventContext eventContext, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry) {
        this.eventContext = eventContext;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
    }

    public <F> StandardIndexFieldTypeContext<?, F> as(Class<F> inputType) {
        if (String.class.equals(inputType)) {
            return this.asString();
        }
        if (Integer.class.equals(inputType)) {
            return this.asInteger();
        }
        if (Long.class.equals(inputType)) {
            return this.asLong();
        }
        if (Boolean.class.equals(inputType)) {
            return this.asBoolean();
        }
        if (LocalDate.class.equals(inputType)) {
            return this.asLocalDate();
        }
        if (Instant.class.equals(inputType)) {
            return this.asInstant();
        }
        if (GeoPoint.class.equals(inputType)) {
            return this.asGeoPoint();
        }
        throw log.cannotGuessFieldType(inputType, this.getEventContext());
    }

    public StringIndexFieldTypeContext<?> asString() {
        return new LuceneStringIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Integer> asInteger() {
        return new LuceneIntegerIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Long> asLong() {
        return new LuceneLongIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Boolean> asBoolean() {
        return new LuceneBooleanIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, LocalDate> asLocalDate() {
        return new LuceneLocalDateIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Instant> asInstant() {
        return new LuceneInstantIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, GeoPoint> asGeoPoint() {
        return new LuceneGeoPointIndexFieldTypeContext(this);
    }

    @Override
    public <F> IndexFieldTypeTerminalContext<F> asLuceneField(Class<F> indexFieldType, LuceneFieldContributor<F> fieldContributor, LuceneFieldValueExtractor<F> fieldValueExtractor) {
        return new LuceneFieldIndexFieldTypeContext<F>(indexFieldType, fieldContributor, fieldValueExtractor);
    }

    @Override
    public EventContext getEventContext() {
        return this.eventContext;
    }

    @Override
    public LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry() {
        return this.analysisDefinitionRegistry;
    }
}

