/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.LuceneLongFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneLongIndexFieldTypeContext
extends AbstractLuceneStandardIndexFieldTypeContext<LuceneLongIndexFieldTypeContext, Long> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneLongIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Long.class);
    }

    public LuceneLongIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Long> toIndexFieldType() {
        boolean resolvedSortable = LuceneLongIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneLongIndexFieldTypeContext.resolveDefault(this.projectable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneLongFieldCodec codec = new LuceneLongFieldCodec(resolvedProjectable, resolvedSortable);
        return new LuceneIndexFieldType<Long>(codec, new LuceneNumericFieldPredicateBuilderFactory<Long, Long>((ToDocumentFieldValueConverter<?, Long>)dslToIndexConverter, codec), new LuceneNumericFieldSortBuilderFactory<Long, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, Long>)dslToIndexConverter, codec), new LuceneStandardFieldProjectionBuilderFactory<Long>(resolvedProjectable, indexToProjectionConverter, codec));
    }

    @Override
    protected LuceneLongIndexFieldTypeContext thisAsS() {
        return this;
    }
}

