/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.util.impl.common.Contracts;
import org.hibernate.search.util.impl.common.LoggerFactory;

abstract class AbstractLuceneStandardFieldPredicateBuilderFactory<F, C extends LuceneStandardFieldCodec<F, ?>>
implements LuceneFieldPredicateBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    final ToDocumentFieldValueConverter<?, ? extends F> converter;
    final C codec;

    AbstractLuceneStandardFieldPredicateBuilderFactory(ToDocumentFieldValueConverter<?, ? extends F> converter, C codec) {
        Contracts.assertNotNull(converter, (String)"converter");
        Contracts.assertNotNull(codec, (String)"codec");
        this.converter = converter;
        this.codec = codec;
    }

    @Override
    public boolean isDslCompatibleWith(LuceneFieldPredicateBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AbstractLuceneStandardFieldPredicateBuilderFactory castedOther = (AbstractLuceneStandardFieldPredicateBuilderFactory)other;
        return this.converter.isCompatibleWith(castedOther.converter) && this.codec.isCompatibleWith((LuceneFieldCodec<?>)castedOther.codec);
    }

    @Override
    public SpatialWithinCirclePredicateBuilder<LuceneSearchPredicateBuilder> createSpatialWithinCirclePredicateBuilder(String absoluteFieldPath) {
        throw log.spatialPredicatesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public SpatialWithinPolygonPredicateBuilder<LuceneSearchPredicateBuilder> createSpatialWithinPolygonPredicateBuilder(String absoluteFieldPath) {
        throw log.spatialPredicatesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public SpatialWithinBoundingBoxPredicateBuilder<LuceneSearchPredicateBuilder> createSpatialWithinBoundingBoxPredicateBuilder(String absoluteFieldPath) {
        throw log.spatialPredicatesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }
}

