/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneGeoPointSpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneGeoPointSpatialWithinCirclePredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneGeoPointSpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.util.impl.common.LoggerFactory;

public final class LuceneGeoPointFieldPredicateBuilderFactory
implements LuceneFieldPredicateBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final LuceneGeoPointFieldPredicateBuilderFactory INSTANCE = new LuceneGeoPointFieldPredicateBuilderFactory();

    private LuceneGeoPointFieldPredicateBuilderFactory() {
    }

    @Override
    public boolean isDslCompatibleWith(LuceneFieldPredicateBuilderFactory other) {
        return INSTANCE == other;
    }

    @Override
    public MatchPredicateBuilder<LuceneSearchPredicateBuilder> createMatchPredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath) {
        throw log.matchPredicatesNotSupportedByGeoPoint(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public RangePredicateBuilder<LuceneSearchPredicateBuilder> createRangePredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath) {
        throw log.rangePredicatesNotSupportedByGeoPoint(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public SpatialWithinCirclePredicateBuilder<LuceneSearchPredicateBuilder> createSpatialWithinCirclePredicateBuilder(String absoluteFieldPath) {
        return new LuceneGeoPointSpatialWithinCirclePredicateBuilder(absoluteFieldPath);
    }

    @Override
    public SpatialWithinPolygonPredicateBuilder<LuceneSearchPredicateBuilder> createSpatialWithinPolygonPredicateBuilder(String absoluteFieldPath) {
        return new LuceneGeoPointSpatialWithinPolygonPredicateBuilder(absoluteFieldPath);
    }

    @Override
    public SpatialWithinBoundingBoxPredicateBuilder<LuceneSearchPredicateBuilder> createSpatialWithinBoundingBoxPredicateBuilder(String absoluteFieldPath) {
        return new LuceneGeoPointSpatialWithinBoundingBoxPredicateBuilder(absoluteFieldPath);
    }
}

