/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.Objects;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.backend.lucene.types.predicate.impl.AbstractLuceneStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextMatchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextRangePredicateBuilder;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

public final class LuceneTextFieldPredicateBuilderFactory<F>
extends AbstractLuceneStandardFieldPredicateBuilderFactory<F, LuceneTextFieldCodec<F>> {
    private final QueryBuilder queryBuilder;

    public LuceneTextFieldPredicateBuilderFactory(ToDocumentFieldValueConverter<?, ? extends F> converter, LuceneTextFieldCodec<F> codec, QueryBuilder queryBuilder) {
        super(converter, codec);
        this.queryBuilder = queryBuilder;
    }

    @Override
    public boolean isDslCompatibleWith(LuceneFieldPredicateBuilderFactory other) {
        if (!super.isDslCompatibleWith(other)) {
            return false;
        }
        LuceneTextFieldPredicateBuilderFactory castedOther = (LuceneTextFieldPredicateBuilderFactory)other;
        return Objects.equals(this.queryBuilder, castedOther.queryBuilder);
    }

    public LuceneTextMatchPredicateBuilder<?> createMatchPredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath) {
        return new LuceneTextMatchPredicateBuilder(searchContext, absoluteFieldPath, this.converter, (LuceneTextFieldCodec)this.codec, this.queryBuilder);
    }

    public LuceneTextRangePredicateBuilder<?> createRangePredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath) {
        return new LuceneTextRangePredicateBuilder(searchContext, absoluteFieldPath, this.converter, (LuceneTextFieldCodec)this.codec);
    }
}

