/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneStandardMatchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneTextMatchPredicateBuilder<F>
extends AbstractLuceneStandardMatchPredicateBuilder<F, String, LuceneTextFieldCodec<F>> {
    private final QueryBuilder queryBuilder;

    LuceneTextMatchPredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> converter, LuceneTextFieldCodec<F> codec, QueryBuilder queryBuilder) {
        super(searchContext, absoluteFieldPath, converter, codec);
        this.queryBuilder = queryBuilder;
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        if (this.queryBuilder != null) {
            Query analyzed = this.queryBuilder.createBooleanQuery(this.absoluteFieldPath, (String)this.value);
            if (analyzed == null) {
                analyzed = new MatchNoDocsQuery("No tokens after analysis of the value to match");
            }
            return analyzed;
        }
        return new TermQuery(new Term(this.absoluteFieldPath, ((LuceneTextFieldCodec)this.codec).normalize(this.absoluteFieldPath, (String)this.value)));
    }
}

