/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.document.LatLonDocValuesField;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.sort.impl.AbstractLuceneSearchSortBuilder;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilder;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.engine.search.dsl.sort.SortOrder;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class LuceneGeoPointDistanceSortBuilder
extends AbstractLuceneSearchSortBuilder
implements DistanceSortBuilder<LuceneSearchSortBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String absoluteFieldPath;
    private final GeoPoint location;

    LuceneGeoPointDistanceSortBuilder(String absoluteFieldPath, GeoPoint location) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.location = location;
    }

    @Override
    public void order(SortOrder order) {
        if (SortOrder.DESC == order) {
            throw log.descendingOrderNotSupportedByDistanceSort(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    @Override
    public void buildAndContribute(LuceneSearchSortCollector collector) {
        collector.collectSortField(LatLonDocValuesField.newDistanceSort((String)this.absoluteFieldPath, (double)this.location.getLatitude(), (double)this.location.getLongitude()));
    }
}

