/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.util.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.impl.common.LoggerFactory;

public final class AnalyzerUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private AnalyzerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String normalize(Analyzer analyzer, String fieldName, String text) {
        String string;
        TokenStream stream = analyzer.tokenStream(fieldName, (Reader)new StringReader(text));
        try {
            String firstToken = null;
            CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            stream.reset();
            if (stream.incrementToken()) {
                firstToken = new String(term.buffer(), 0, term.length());
                if (stream.incrementToken()) {
                    log.multipleTermsDetectedDuringNormalization(fieldName);
                } else {
                    stream.end();
                }
            }
            string = firstToken;
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException | SearchException e) {
                throw log.couldNotNormalizeField(fieldName, (Exception)e);
            }
        }
        stream.close();
        return string;
    }
}

