/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.AbstractLuceneWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneIndexWorkExecutionContext;
import org.hibernate.search.util.impl.common.Futures;
import org.hibernate.search.util.impl.common.LoggerFactory;

public abstract class AbstractLuceneDeleteAllEntriesWork
extends AbstractLuceneWork<Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String tenantId;

    public AbstractLuceneDeleteAllEntriesWork(String indexName, String tenantId) {
        super("deleteAllEntries", indexName);
        this.tenantId = tenantId;
    }

    @Override
    public CompletableFuture<Long> execute(LuceneIndexWorkExecutionContext context) {
        return Futures.create(() -> CompletableFuture.completedFuture(this.deleteDocuments(context.getIndexWriter())));
    }

    private Long deleteDocuments(IndexWriter indexWriter) {
        try {
            return this.doDeleteDocuments(indexWriter, this.tenantId);
        }
        catch (IOException e) {
            throw log.unableToDeleteAllEntriesFromIndex(this.tenantId, this.getEventContext(), e);
        }
    }

    protected abstract long doDeleteDocuments(IndexWriter var1, String var2) throws IOException;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("type=").append(this.workType).append(", indexName=").append(this.indexName).append("]");
        return sb.toString();
    }
}

