/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.AbstractLuceneWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneIndexWorkExecutionContext;
import org.hibernate.search.util.impl.common.Futures;
import org.hibernate.search.util.impl.common.LoggerFactory;

public abstract class AbstractLuceneUpdateEntryWork
extends AbstractLuceneWork<Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String tenantId;
    private final String id;
    private final LuceneIndexEntry indexEntry;

    protected AbstractLuceneUpdateEntryWork(String indexName, String tenantId, String id, LuceneIndexEntry indexEntry) {
        super("updateEntry", indexName);
        this.tenantId = tenantId;
        this.id = id;
        this.indexEntry = indexEntry;
    }

    @Override
    public CompletableFuture<Long> execute(LuceneIndexWorkExecutionContext context) {
        return Futures.create(() -> CompletableFuture.completedFuture(this.updateEntry(context.getIndexWriter())));
    }

    private long updateEntry(IndexWriter indexWriter) {
        try {
            return this.doUpdateEntry(indexWriter, this.tenantId, this.id, this.indexEntry);
        }
        catch (IOException e) {
            throw log.unableToIndexEntry(this.tenantId, this.id, this.getEventContext(), e);
        }
    }

    protected abstract long doUpdateEntry(IndexWriter var1, String var2, String var3, LuceneIndexEntry var4) throws IOException;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("type=").append(this.workType).append(", entry=").append(this.indexEntry).append("]");
        return sb.toString();
    }
}

