/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.AbstractLuceneWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneIndexWorkExecutionContext;
import org.hibernate.search.util.impl.common.Futures;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class LuceneCommitIndexWork
extends AbstractLuceneWork<Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public LuceneCommitIndexWork(String indexName) {
        super("commitIndex", indexName);
    }

    @Override
    public CompletableFuture<Long> execute(LuceneIndexWorkExecutionContext context) {
        return Futures.create(() -> this.commitIndex(context.getIndexWriter()));
    }

    private CompletableFuture<Long> commitIndex(IndexWriter indexWriter) {
        try {
            return CompletableFuture.completedFuture(indexWriter.commit());
        }
        catch (IOException e) {
            throw log.unableToCommitIndex(this.getEventContext(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("type=").append(this.workType).append(", indexName=").append(this.indexName).append("]");
        return sb.toString();
    }
}

