/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.LuceneQueryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneQueryWorkExecutionContext;
import org.hibernate.search.util.impl.common.Futures;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class LuceneExecuteQueryWork<T>
implements LuceneQueryWork<LuceneLoadableSearchResult<T>> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearcher<T> searcher;

    public LuceneExecuteQueryWork(LuceneSearcher<T> searcher) {
        this.searcher = searcher;
    }

    @Override
    public CompletableFuture<LuceneLoadableSearchResult<T>> execute(LuceneQueryWorkExecutionContext context) {
        return Futures.create(() -> CompletableFuture.completedFuture(this.executeQuery(this.searcher)));
    }

    private LuceneLoadableSearchResult<T> executeQuery(LuceneSearcher<T> searcher) {
        try {
            LuceneLoadableSearchResult<T> luceneLoadableSearchResult = searcher.execute();
            return luceneLoadableSearchResult;
        }
        catch (IOException e) {
            throw log.ioExceptionOnQueryExecution(searcher.getLuceneQuery(), searcher.getEventContext(), e);
        }
        finally {
            searcher.close();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("searcher=").append(this.searcher).append("]");
        return sb.toString();
    }
}

