/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.backend.lucene.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexSearchScopeBuilder;
import org.hibernate.search.backend.lucene.index.spi.ReaderProvider;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneIndexWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneStubIndexWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.backend.index.spi.IndexSearchScopeBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexWorkPlan;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class LuceneIndexManagerImpl
implements IndexManagerImplementor<LuceneRootDocumentBuilder>,
LuceneIndexManager,
ReaderProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexingBackendContext indexingBackendContext;
    private final SearchBackendContext searchBackendContext;
    private final String indexName;
    private final LuceneIndexModel model;
    private final LuceneIndexWorkOrchestrator serialOrchestrator;
    private final LuceneIndexWorkOrchestrator parallelOrchestrator;
    private final IndexWriter indexWriter;

    LuceneIndexManagerImpl(IndexingBackendContext indexingBackendContext, SearchBackendContext searchBackendContext, String indexName, LuceneIndexModel model, IndexWriter indexWriter) {
        this.indexingBackendContext = indexingBackendContext;
        this.searchBackendContext = searchBackendContext;
        this.indexName = indexName;
        this.model = model;
        this.serialOrchestrator = new LuceneStubIndexWorkOrchestrator(indexWriter);
        this.parallelOrchestrator = new LuceneStubIndexWorkOrchestrator(indexWriter);
        this.indexWriter = indexWriter;
    }

    LuceneIndexModel getModel() {
        return this.model;
    }

    public void start(IndexManagerStartContext context) {
    }

    public IndexWorkPlan<LuceneRootDocumentBuilder> createWorkPlan(SessionContextImplementor sessionContext) {
        return this.indexingBackendContext.createWorkPlan(this.serialOrchestrator, this.indexName, sessionContext);
    }

    public IndexDocumentWorkExecutor<LuceneRootDocumentBuilder> createDocumentWorkExecutor(SessionContextImplementor sessionContext) {
        return this.indexingBackendContext.createDocumentWorkExecutor(this.parallelOrchestrator, this.indexName, sessionContext);
    }

    public IndexWorkExecutor createWorkExecutor() {
        return this.indexingBackendContext.createWorkExecutor(this.parallelOrchestrator, this.indexName);
    }

    public IndexSearchScopeBuilder createSearchScopeBuilder(MappingContextImplementor mappingContext) {
        return new LuceneIndexSearchScopeBuilder(this.searchBackendContext, mappingContext, this);
    }

    public void addTo(IndexSearchScopeBuilder builder) {
        if (!(builder instanceof LuceneIndexSearchScopeBuilder)) {
            throw log.cannotMixLuceneSearchScopeWithOtherType(builder, this, this.searchBackendContext.getEventContext());
        }
        LuceneIndexSearchScopeBuilder luceneBuilder = (LuceneIndexSearchScopeBuilder)builder;
        luceneBuilder.add(this.searchBackendContext, this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.indexName + "]";
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(LuceneIndexWorkOrchestrator::close, (Object)this.serialOrchestrator);
            closer.push(LuceneIndexWorkOrchestrator::close, (Object)this.parallelOrchestrator);
            closer.push(IndexWriter::close, (Object)this.indexWriter);
            closer.push(LuceneIndexModel::close, (Object)this.model);
        }
        catch (IOException | RuntimeException e) {
            throw log.failedToShutdownBackend(e, this.getBackendAndIndexEventContext());
        }
    }

    ReaderProvider getReaderProvider() {
        return this;
    }

    @Override
    public IndexReader openIndexReader() {
        try {
            return DirectoryReader.open((IndexWriter)this.indexWriter);
        }
        catch (IOException e) {
            throw log.unableToCreateIndexReader(this.getBackendAndIndexEventContext(), e);
        }
    }

    @Override
    public void closeIndexReader(IndexReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            log.unableToCloseIndexReader(this.getBackendAndIndexEventContext(), e);
        }
    }

    public IndexManager toAPI() {
        return this;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(LuceneIndexManager.class)) {
            return (T)this;
        }
        throw log.indexManagerUnwrappingWithUnknownType(clazz, LuceneIndexManager.class, this.getBackendAndIndexEventContext());
    }

    private EventContext getBackendAndIndexEventContext() {
        return this.indexingBackendContext.getEventContext().append(EventContexts.fromIndexName((String)this.indexName));
    }
}

