/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneIndexWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.index.spi.IndexWorkExecutor;
import org.hibernate.search.util.common.reporting.EventContext;

class LuceneIndexWorkExecutor
implements IndexWorkExecutor {
    private final LuceneWorkFactory factory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final LuceneIndexWorkOrchestrator orchestrator;
    private final String indexName;
    private final EventContext eventContext;

    LuceneIndexWorkExecutor(LuceneWorkFactory factory, MultiTenancyStrategy multiTenancyStrategy, LuceneIndexWorkOrchestrator orchestrator, String indexName, EventContext eventContext) {
        this.factory = factory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexName;
        this.eventContext = eventContext;
    }

    public CompletableFuture<?> optimize() {
        return this.orchestrator.submit(this.factory.optimize(this.indexName));
    }

    public CompletableFuture<?> purge(String tenantId) {
        this.multiTenancyStrategy.checkTenantId(tenantId, this.eventContext);
        return this.orchestrator.submit(this.factory.deleteAll(this.indexName, tenantId));
    }

    public CompletableFuture<?> flush() {
        return this.orchestrator.submit(this.factory.flush(this.indexName));
    }
}

