/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.SloppyMath;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class DistanceCollector
implements Collector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String absoluteFieldPath;
    private final GeoPoint center;
    private final SpatialResultsCollector distances;

    public DistanceCollector(String absoluteFieldPath, GeoPoint center, int hitsCount) {
        this.center = center;
        this.absoluteFieldPath = absoluteFieldPath;
        this.distances = new SpatialResultsCollector(hitsCount);
    }

    public Double getDistance(int index) {
        return this.distances.get(index, this.center);
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return new DistanceLeafCollector(context);
    }

    public boolean needsScores() {
        return false;
    }

    private class DistanceLeafCollector
    implements LeafCollector {
        private final int docBase;
        private final SortedNumericDocValues geoPointValues;

        DistanceLeafCollector(LeafReaderContext context) throws IOException {
            LeafReader atomicReader = context.reader();
            this.geoPointValues = DocValues.getSortedNumeric((LeafReader)atomicReader, (String)DistanceCollector.this.absoluteFieldPath);
            this.docBase = context.docBase;
        }

        public void setScorer(Scorer scorer) {
        }

        public void collect(int doc) throws IOException {
            int absolute = this.docBase + doc;
            if (this.geoPointValues.advanceExact(doc)) {
                long encodedValue = this.geoPointValues.nextValue();
                double latitude = GeoEncodingUtils.decodeLatitude((int)((int)(encodedValue >> 32)));
                double longitude = GeoEncodingUtils.decodeLongitude((int)((int)encodedValue));
                DistanceCollector.this.distances.put(absolute, latitude, longitude);
            } else {
                DistanceCollector.this.distances.putIncomplete(absolute);
            }
        }
    }

    private static class SpatialResultsCollector {
        final ArrayList<HitEntry> orderedEntries;
        int currentIterator = 0;

        private SpatialResultsCollector(int size) {
            this.orderedEntries = new ArrayList(size);
        }

        public Double get(int index, GeoPoint center) {
            HitEntry currentEntry;
            int startingPoint = this.currentIterator;
            while (this.currentIterator < this.orderedEntries.size() && (currentEntry = this.orderedEntries.get(this.currentIterator)) != null) {
                if (currentEntry.documentId == index) {
                    return currentEntry.getDistance(center);
                }
                ++this.currentIterator;
            }
            this.currentIterator = 0;
            while (this.currentIterator < startingPoint && (currentEntry = this.orderedEntries.get(this.currentIterator)) != null) {
                if (currentEntry.documentId == index) {
                    return currentEntry.getDistance(center);
                }
                ++this.currentIterator;
            }
            throw log.documentIdNotCollected(index);
        }

        void put(int documentId, double latitude, double longitude) {
            this.orderedEntries.add(new CompleteHitEntry(documentId, latitude, longitude));
        }

        void putIncomplete(int documentId) {
            this.orderedEntries.add(new IncompleteHitEntry(documentId));
        }
    }

    private static final class IncompleteHitEntry
    extends HitEntry {
        private IncompleteHitEntry(int documentId) {
            super(documentId);
        }

        @Override
        public Double getDistance(GeoPoint center) {
            return null;
        }
    }

    private static final class CompleteHitEntry
    extends HitEntry {
        private final double latitude;
        private final double longitude;

        private CompleteHitEntry(int documentId, double latitude, double longitude) {
            super(documentId);
            this.latitude = latitude;
            this.longitude = longitude;
        }

        @Override
        public Double getDistance(GeoPoint center) {
            return SloppyMath.haversinMeters((double)center.getLatitude(), (double)center.getLongitude(), (double)this.latitude, (double)this.longitude);
        }
    }

    private static abstract class HitEntry {
        private final int documentId;

        private HitEntry(int documentId) {
            this.documentId = documentId;
        }

        public abstract Double getDistance(GeoPoint var1);
    }
}

