/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchScopeModel;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilderFactoryImpl;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.search.dsl.spi.IndexSearchScope;

public class LuceneIndexSearchScope
implements IndexSearchScope<LuceneSearchQueryElementCollector> {
    private final LuceneSearchScopeModel model;
    private final LuceneSearchPredicateBuilderFactoryImpl searchPredicateFactory;
    private final LuceneSearchSortBuilderFactoryImpl searchSortFactory;
    private final LuceneSearchQueryBuilderFactory searchQueryFactory;
    private final LuceneSearchProjectionBuilderFactory searchProjectionFactory;

    public LuceneIndexSearchScope(SearchBackendContext searchBackendContext, MappingContextImplementor mappingContext, LuceneSearchScopeModel model) {
        LuceneSearchContext searchContext = new LuceneSearchContext(mappingContext);
        this.model = model;
        this.searchPredicateFactory = new LuceneSearchPredicateBuilderFactoryImpl(searchContext, model);
        this.searchSortFactory = new LuceneSearchSortBuilderFactoryImpl(searchContext, model);
        this.searchProjectionFactory = new LuceneSearchProjectionBuilderFactory(model);
        this.searchQueryFactory = new LuceneSearchQueryBuilderFactory(searchBackendContext, model, this.searchProjectionFactory);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexNames=" + this.model.getIndexNames() + "]";
    }

    public LuceneSearchPredicateBuilderFactoryImpl getSearchPredicateBuilderFactory() {
        return this.searchPredicateFactory;
    }

    public LuceneSearchSortBuilderFactoryImpl getSearchSortBuilderFactory() {
        return this.searchSortFactory;
    }

    public LuceneSearchQueryBuilderFactory getSearchQueryBuilderFactory() {
        return this.searchQueryFactory;
    }

    public LuceneSearchProjectionBuilderFactory getSearchProjectionFactory() {
        return this.searchProjectionFactory;
    }
}

