/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchScopeModel;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeListProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneObjectProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneReferenceProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilder;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilderFactory;

class LuceneSearchQueryBuilderFactory
implements SearchQueryBuilderFactory<LuceneSearchQueryElementCollector> {
    private final SearchBackendContext searchBackendContext;
    private final LuceneSearchScopeModel scopeModel;
    private final LuceneSearchProjectionBuilderFactory searchProjectionFactory;

    LuceneSearchQueryBuilderFactory(SearchBackendContext searchBackendContext, LuceneSearchScopeModel scopeModel, LuceneSearchProjectionBuilderFactory searchProjectionFactory) {
        this.searchBackendContext = searchBackendContext;
        this.scopeModel = scopeModel;
        this.searchProjectionFactory = searchProjectionFactory;
    }

    public <O> SearchQueryBuilder<O, LuceneSearchQueryElementCollector> asObject(SessionContextImplementor sessionContext, ProjectionHitMapper<?, O> projectionHitMapper) {
        return this.createSearchQueryBuilder(sessionContext, projectionHitMapper, LuceneObjectProjection.get());
    }

    public <T> SearchQueryBuilder<T, LuceneSearchQueryElementCollector> asReference(SessionContextImplementor sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper) {
        return this.createSearchQueryBuilder(sessionContext, projectionHitMapper, LuceneReferenceProjection.get());
    }

    public <T> SearchQueryBuilder<T, LuceneSearchQueryElementCollector> asProjection(SessionContextImplementor sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper, SearchProjection<T> projection) {
        return this.createSearchQueryBuilder(sessionContext, projectionHitMapper, this.searchProjectionFactory.toImplementation(projection));
    }

    public SearchQueryBuilder<List<?>, LuceneSearchQueryElementCollector> asProjections(SessionContextImplementor sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper, SearchProjection<?> ... projections) {
        return this.createSearchQueryBuilder(sessionContext, projectionHitMapper, this.createRootProjection(projections));
    }

    private LuceneSearchProjection<?, List<?>> createRootProjection(SearchProjection<?>[] projections) {
        ArrayList children = new ArrayList(projections.length);
        for (SearchProjection<?> projection : projections) {
            children.add(this.searchProjectionFactory.toImplementation(projection));
        }
        return new LuceneCompositeListProjection(Function.identity(), children);
    }

    private <T> LuceneSearchQueryBuilder<T> createSearchQueryBuilder(SessionContextImplementor sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper, LuceneSearchProjection<?, T> rootProjection) {
        return this.searchBackendContext.createSearchQueryBuilder(this.scopeModel, sessionContext, projectionHitMapper, rootProjection);
    }
}

