/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneQueryWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchScopeModel;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilder;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;
import org.hibernate.search.util.common.reporting.EventContext;

public class SearchBackendContext {
    private final EventContext eventContext;
    private final LuceneWorkFactory workFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final LuceneQueryWorkOrchestrator orchestrator;

    public SearchBackendContext(EventContext eventContext, LuceneWorkFactory workFactory, MultiTenancyStrategy multiTenancyStrategy, LuceneQueryWorkOrchestrator orchestrator) {
        this.eventContext = eventContext;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.workFactory = workFactory;
        this.orchestrator = orchestrator;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    <T> LuceneSearchQueryBuilder<T> createSearchQueryBuilder(LuceneSearchScopeModel scopeModel, SessionContextImplementor sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper, LuceneSearchProjection<?, T> rootProjection) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        LuceneDocumentStoredFieldVisitorBuilder storedFieldFilterBuilder = new LuceneDocumentStoredFieldVisitorBuilder();
        rootProjection.contributeFields(storedFieldFilterBuilder);
        return new LuceneSearchQueryBuilder<T>(this.workFactory, this.orchestrator, this.multiTenancyStrategy, scopeModel, sessionContext, storedFieldFilterBuilder.build(), projectionHitMapper, rootProjection);
    }
}

