/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericFieldCodec;

public final class LuceneDoubleFieldCodec
implements LuceneNumericFieldCodec<Double, Double> {
    private final boolean projectable;
    private final boolean sortable;

    public LuceneDoubleFieldCodec(boolean projectable, boolean sortable) {
        this.projectable = projectable;
        this.sortable = sortable;
    }

    @Override
    public void encode(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Double value) {
        if (value == null) {
            return;
        }
        if (this.projectable) {
            documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, value.doubleValue()));
        }
        if (this.sortable) {
            documentBuilder.addField((IndexableField)new DoubleDocValuesField(absoluteFieldPath, value.doubleValue()));
        }
        documentBuilder.addField((IndexableField)new DoublePoint(absoluteFieldPath, new double[]{value}));
    }

    @Override
    public Double decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        return (Double)field.numericValue();
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (LuceneDoubleFieldCodec.class != obj.getClass()) {
            return false;
        }
        LuceneDoubleFieldCodec other = (LuceneDoubleFieldCodec)obj;
        return this.projectable == other.projectable && this.sortable == other.sortable;
    }

    @Override
    public Double encode(Double value) {
        return value;
    }

    @Override
    public LuceneNumericDomain<Double> getDomain() {
        return LuceneNumericDomain.DOUBLE;
    }
}

