/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericFieldCodec;

public final class LuceneFloatFieldCodec
implements LuceneNumericFieldCodec<Float, Float> {
    private final boolean projectable;
    private final boolean sortable;

    public LuceneFloatFieldCodec(boolean projectable, boolean sortable) {
        this.projectable = projectable;
        this.sortable = sortable;
    }

    @Override
    public void encode(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Float value) {
        if (value == null) {
            return;
        }
        if (this.projectable) {
            documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, value.floatValue()));
        }
        if (this.sortable) {
            documentBuilder.addField((IndexableField)new FloatDocValuesField(absoluteFieldPath, value.floatValue()));
        }
        documentBuilder.addField((IndexableField)new FloatPoint(absoluteFieldPath, new float[]{value.floatValue()}));
    }

    @Override
    public Float decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        return (Float)field.numericValue();
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (LuceneFloatFieldCodec.class != obj.getClass()) {
            return false;
        }
        LuceneFloatFieldCodec other = (LuceneFloatFieldCodec)obj;
        return this.projectable == other.projectable && this.sortable == other.sortable;
    }

    @Override
    public Float encode(Float value) {
        return value;
    }

    @Override
    public LuceneNumericDomain<Float> getDomain() {
        return LuceneNumericDomain.FLOAT;
    }
}

