/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericFieldCodec;

public final class LuceneLocalTimeFieldCodec
implements LuceneNumericFieldCodec<LocalTime, Long> {
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 3, 9, true).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    private final boolean projectable;
    private final boolean sortable;

    public LuceneLocalTimeFieldCodec(boolean projectable, boolean sortable) {
        this.projectable = projectable;
        this.sortable = sortable;
    }

    @Override
    public void encode(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, LocalTime value) {
        if (value == null) {
            return;
        }
        if (this.projectable) {
            documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, FORMATTER.format(value)));
        }
        long numericValue = this.encode(value);
        if (this.sortable) {
            documentBuilder.addField((IndexableField)new NumericDocValuesField(absoluteFieldPath, numericValue));
        }
        documentBuilder.addField((IndexableField)new LongPoint(absoluteFieldPath, new long[]{numericValue}));
    }

    @Override
    public LocalTime decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        String value = field.stringValue();
        if (value == null) {
            return null;
        }
        return LocalTime.parse(value, FORMATTER);
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (LuceneLocalTimeFieldCodec.class != obj.getClass()) {
            return false;
        }
        LuceneLocalTimeFieldCodec other = (LuceneLocalTimeFieldCodec)obj;
        return this.projectable == other.projectable && this.sortable == other.sortable;
    }

    @Override
    public Long encode(LocalTime value) {
        return value == null ? null : Long.valueOf(value.toNanoOfDay());
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneNumericDomain.LONG;
    }
}

