/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericFieldCodec;

public final class LuceneMonthDayFieldCodec
implements LuceneNumericFieldCodec<MonthDay, Integer> {
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    private final boolean projectable;
    private final boolean sortable;

    public LuceneMonthDayFieldCodec(boolean projectable, boolean sortable) {
        this.projectable = projectable;
        this.sortable = sortable;
    }

    @Override
    public void encode(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, MonthDay value) {
        if (value == null) {
            return;
        }
        if (this.projectable) {
            documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, FORMATTER.format(value)));
        }
        Integer integerValue = this.encode(value);
        if (this.sortable) {
            documentBuilder.addField((IndexableField)new NumericDocValuesField(absoluteFieldPath, (long)integerValue.intValue()));
        }
        documentBuilder.addField((IndexableField)new IntPoint(absoluteFieldPath, new int[]{integerValue}));
    }

    @Override
    public MonthDay decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        String value = field.stringValue();
        if (value == null) {
            return null;
        }
        return MonthDay.parse(value, FORMATTER);
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (LuceneMonthDayFieldCodec.class != obj.getClass()) {
            return false;
        }
        LuceneMonthDayFieldCodec other = (LuceneMonthDayFieldCodec)obj;
        return this.projectable == other.projectable && this.sortable == other.sortable;
    }

    @Override
    public Integer encode(MonthDay value) {
        if (value == null) {
            return null;
        }
        return 100 * value.getMonthValue() + value.getDayOfMonth();
    }

    @Override
    public LuceneNumericDomain<Integer> getDomain() {
        return LuceneNumericDomain.INTEGER;
    }
}

