/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.backend.lucene.util.impl.AnalyzerUtils;

public final class LuceneStringFieldCodec
implements LuceneTextFieldCodec<String> {
    private final boolean sortable;
    private final FieldType fieldType;
    private final Analyzer analyzerOrNormalizer;

    public LuceneStringFieldCodec(boolean sortable, FieldType fieldType, Analyzer analyzerOrNormalizer) {
        this.sortable = sortable;
        this.fieldType = fieldType;
        this.analyzerOrNormalizer = analyzerOrNormalizer;
    }

    @Override
    public void encode(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, String value) {
        if (value == null) {
            return;
        }
        documentBuilder.addField((IndexableField)new Field(absoluteFieldPath, (CharSequence)value, (IndexableFieldType)this.fieldType));
        if (this.sortable) {
            documentBuilder.addField((IndexableField)new SortedDocValuesField(absoluteFieldPath, new BytesRef((CharSequence)this.normalize(absoluteFieldPath, value))));
        }
    }

    @Override
    public String decode(Document document, String absoluteFieldPath) {
        return document.get(absoluteFieldPath);
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (LuceneStringFieldCodec.class != obj.getClass()) {
            return false;
        }
        LuceneStringFieldCodec other = (LuceneStringFieldCodec)obj;
        return this.sortable == other.sortable && Objects.equals(this.fieldType, other.fieldType) && Objects.equals(this.analyzerOrNormalizer, other.analyzerOrNormalizer);
    }

    @Override
    public String encode(String value) {
        return value;
    }

    @Override
    public String normalize(String absoluteFieldPath, String value) {
        if (value == null) {
            return null;
        }
        return this.analyzerOrNormalizer != null ? AnalyzerUtils.normalize(this.analyzerOrNormalizer, absoluteFieldPath, value) : value;
    }
}

