/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.LocalTime;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneLocalTimeFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneLocalTimeIndexFieldTypeContext
extends AbstractLuceneStandardIndexFieldTypeContext<LuceneLocalTimeIndexFieldTypeContext, LocalTime> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneLocalTimeIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, LocalTime.class);
    }

    public LuceneLocalTimeIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<LocalTime> toIndexFieldType() {
        boolean resolvedSortable = LuceneLocalTimeIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneLocalTimeIndexFieldTypeContext.resolveDefault(this.projectable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneLocalTimeFieldCodec codec = new LuceneLocalTimeFieldCodec(resolvedProjectable, resolvedSortable);
        return new LuceneIndexFieldType<LocalTime>(codec, new LuceneNumericFieldPredicateBuilderFactory<LocalTime, Long>((ToDocumentFieldValueConverter<?, LocalTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<LocalTime, LocalTime>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<LocalTime, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, LocalTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<LocalTime, LocalTime>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<LocalTime>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneLocalTimeIndexFieldTypeContext thisAsS() {
        return this;
    }
}

