/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStringFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneTextFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneStringIndexFieldTypeContext
extends AbstractLuceneStandardIndexFieldTypeContext<LuceneStringIndexFieldTypeContext, String>
implements StringIndexFieldTypeContext<LuceneStringIndexFieldTypeContext> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private String analyzerName;
    private Analyzer analyzer;
    private String normalizerName;
    private Analyzer normalizer;
    private Sortable sortable = Sortable.DEFAULT;

    LuceneStringIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, String.class);
    }

    public LuceneStringIndexFieldTypeContext analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        this.analyzer = this.getAnalysisDefinitionRegistry().getAnalyzerDefinition(analyzerName);
        if (this.analyzer == null) {
            throw log.unknownAnalyzer(analyzerName, this.getBuildContext().getEventContext());
        }
        return this;
    }

    public LuceneStringIndexFieldTypeContext normalizer(String normalizerName) {
        this.normalizerName = normalizerName;
        this.normalizer = this.getAnalysisDefinitionRegistry().getNormalizerDefinition(normalizerName);
        if (this.normalizer == null) {
            throw log.unknownNormalizer(normalizerName, this.getBuildContext().getEventContext());
        }
        return this;
    }

    public LuceneStringIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<String> toIndexFieldType() {
        boolean resolvedSortable = LuceneStringIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneStringIndexFieldTypeContext.resolveDefault(this.projectable);
        if (this.analyzer != null) {
            if (resolvedSortable) {
                throw log.cannotUseAnalyzerOnSortableField(this.analyzerName, this.getBuildContext().getEventContext());
            }
            if (this.normalizer != null) {
                throw log.cannotApplyAnalyzerAndNormalizer(this.analyzerName, this.normalizerName, this.getBuildContext().getEventContext());
            }
        }
        Analyzer analyzerOrNormalizer = this.analyzer != null ? this.analyzer : this.normalizer;
        QueryBuilder queryBuilder = analyzerOrNormalizer != null ? new QueryBuilder(analyzerOrNormalizer) : null;
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneStringFieldCodec codec = new LuceneStringFieldCodec(resolvedSortable, LuceneStringIndexFieldTypeContext.getFieldType(resolvedProjectable, this.analyzer != null), analyzerOrNormalizer);
        return new LuceneIndexFieldType<String>(codec, new LuceneTextFieldPredicateBuilderFactory<String>(dslToIndexConverter, this.createToDocumentRawConverter(), codec, queryBuilder), new LuceneTextFieldSortBuilderFactory<String>(resolvedSortable, (ToDocumentFieldValueConverter<?, String>)dslToIndexConverter, (ToDocumentFieldValueConverter<String, String>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<String>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec), analyzerOrNormalizer);
    }

    @Override
    protected LuceneStringIndexFieldTypeContext thisAsS() {
        return this;
    }

    private LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry() {
        return this.getBuildContext().getAnalysisDefinitionRegistry();
    }

    private static FieldType getFieldType(boolean projectable, boolean analyzed) {
        FieldType fieldType = new FieldType();
        if (analyzed) {
            fieldType.setOmitNorms(false);
            fieldType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            fieldType.setStoreTermVectors(true);
            fieldType.setStoreTermVectorPositions(true);
            fieldType.setStoreTermVectorOffsets(true);
            fieldType.setTokenized(true);
        } else {
            fieldType.setOmitNorms(true);
            fieldType.setIndexOptions(IndexOptions.DOCS);
            fieldType.setTokenized(true);
        }
        fieldType.setStored(projectable);
        fieldType.freeze();
        return fieldType;
    }
}

