/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;

class LuceneTextPhrasePredicateBuilder
extends AbstractLuceneSearchPredicateBuilder
implements PhrasePredicateBuilder<LuceneSearchPredicateBuilder> {
    protected final String absoluteFieldPath;
    protected final LuceneTextFieldCodec<?> codec;
    private final QueryBuilder queryBuilder;
    private int slop;
    private String phrase;

    LuceneTextPhrasePredicateBuilder(String absoluteFieldPath, LuceneTextFieldCodec<?> codec, QueryBuilder queryBuilder) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.codec = codec;
        this.queryBuilder = queryBuilder;
    }

    public void slop(int slop) {
        this.slop = slop;
    }

    public void phrase(String phrase) {
        this.phrase = phrase;
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        if (this.queryBuilder != null) {
            Query analyzed = this.queryBuilder.createPhraseQuery(this.absoluteFieldPath, this.phrase, this.slop);
            if (analyzed == null) {
                analyzed = new MatchNoDocsQuery("No tokens after analysis of the phrase to match");
            }
            return analyzed;
        }
        return new TermQuery(new Term(this.absoluteFieldPath, this.codec.normalize(this.absoluteFieldPath, this.phrase)));
    }
}

