/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.projection.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDistanceToFieldProjectionBuilder;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjectionBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionConverter;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneGeoPointFieldProjectionBuilderFactory
implements LuceneFieldProjectionBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final boolean projectable;
    private final FromDocumentFieldValueConverter<? super GeoPoint, ?> converter;
    private final FromDocumentFieldValueConverter<? super GeoPoint, GeoPoint> rawConverter;
    private final LuceneFieldCodec<GeoPoint> codec;

    public LuceneGeoPointFieldProjectionBuilderFactory(boolean projectable, LuceneFieldCodec<GeoPoint> codec, FromDocumentFieldValueConverter<? super GeoPoint, ?> converter, FromDocumentFieldValueConverter<? super GeoPoint, GeoPoint> rawConverter) {
        this.projectable = projectable;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.codec = codec;
    }

    public <T> FieldProjectionBuilder<T> createFieldValueProjectionBuilder(String absoluteFieldPath, Class<T> expectedType, ProjectionConverter projectionConverter) {
        LuceneGeoPointFieldProjectionBuilderFactory.checkProjectable(absoluteFieldPath, this.projectable);
        FromDocumentFieldValueConverter<? super GeoPoint, ?> requestConverter = this.getConverter(projectionConverter);
        if (!requestConverter.isConvertedTypeAssignableTo(expectedType)) {
            throw log.invalidProjectionInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return new LuceneFieldProjectionBuilder(absoluteFieldPath, requestConverter, this.codec);
    }

    @Override
    public DistanceToFieldProjectionBuilder createDistanceProjectionBuilder(String absoluteFieldPath, GeoPoint center) {
        LuceneGeoPointFieldProjectionBuilderFactory.checkProjectable(absoluteFieldPath, this.projectable);
        return new LuceneDistanceToFieldProjectionBuilder(absoluteFieldPath, center);
    }

    @Override
    public boolean isDslCompatibleWith(LuceneFieldProjectionBuilderFactory obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != LuceneGeoPointFieldProjectionBuilderFactory.class) {
            return false;
        }
        LuceneGeoPointFieldProjectionBuilderFactory other = (LuceneGeoPointFieldProjectionBuilderFactory)obj;
        return this.projectable == other.projectable && this.converter.isCompatibleWith(other.converter) && this.codec.isCompatibleWith(other.codec);
    }

    private static void checkProjectable(String absoluteFieldPath, boolean projectable) {
        if (!projectable) {
            throw log.nonProjectableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }

    private FromDocumentFieldValueConverter<? super GeoPoint, ?> getConverter(ProjectionConverter projectionConverter) {
        return projectionConverter.isEnabled() ? this.converter : this.rawConverter;
    }
}

