/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.projection.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjectionBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionConverter;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneStandardFieldProjectionBuilderFactory<F>
implements LuceneFieldProjectionBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final boolean projectable;
    private final FromDocumentFieldValueConverter<? super F, ?> converter;
    private final FromDocumentFieldValueConverter<? super F, F> rawConverter;
    private final LuceneFieldCodec<F> codec;

    public LuceneStandardFieldProjectionBuilderFactory(boolean projectable, FromDocumentFieldValueConverter<? super F, ?> converter, FromDocumentFieldValueConverter<? super F, F> rawConverter, LuceneFieldCodec<F> codec) {
        this.projectable = projectable;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.codec = codec;
    }

    public <T> FieldProjectionBuilder<T> createFieldValueProjectionBuilder(String absoluteFieldPath, Class<T> expectedType, ProjectionConverter projectionConverter) {
        LuceneStandardFieldProjectionBuilderFactory.checkProjectable(absoluteFieldPath, this.projectable);
        FromDocumentFieldValueConverter<F, ?> requestConverter = this.getConverter(projectionConverter);
        if (!requestConverter.isConvertedTypeAssignableTo(expectedType)) {
            throw log.invalidProjectionInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return new LuceneFieldProjectionBuilder(absoluteFieldPath, requestConverter, this.codec);
    }

    @Override
    public DistanceToFieldProjectionBuilder createDistanceProjectionBuilder(String absoluteFieldPath, GeoPoint center) {
        throw log.distanceOperationsNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public boolean isDslCompatibleWith(LuceneFieldProjectionBuilderFactory obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != LuceneStandardFieldProjectionBuilderFactory.class) {
            return false;
        }
        LuceneStandardFieldProjectionBuilderFactory other = (LuceneStandardFieldProjectionBuilderFactory)obj;
        return this.projectable == other.projectable && this.codec.isCompatibleWith(other.codec) && this.converter.isCompatibleWith(other.converter);
    }

    private static void checkProjectable(String absoluteFieldPath, boolean projectable) {
        if (!projectable) {
            throw log.nonProjectableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }

    private FromDocumentFieldValueConverter<? super F, ?> getConverter(ProjectionConverter projectionConverter) {
        return projectionConverter.isEnabled() ? this.converter : this.rawConverter;
    }
}

