/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.AbstractLuceneWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneIndexWorkExecutionContext;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneAddEntryWork
extends AbstractLuceneWork<Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String tenantId;
    private final String id;
    private final LuceneIndexEntry indexEntry;

    public LuceneAddEntryWork(String indexName, String tenantId, String id, LuceneIndexEntry indexEntry) {
        super("addEntry", indexName);
        this.tenantId = tenantId;
        this.id = id;
        this.indexEntry = indexEntry;
    }

    @Override
    public CompletableFuture<Long> execute(LuceneIndexWorkExecutionContext context) {
        return Futures.create(() -> this.addEntry(context.getIndexWriter()));
    }

    private CompletableFuture<Long> addEntry(IndexWriter indexWriter) {
        try {
            return CompletableFuture.completedFuture(indexWriter.addDocuments((Iterable)this.indexEntry));
        }
        catch (IOException e) {
            throw log.unableToIndexEntry(this.tenantId, this.id, this.getEventContext(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("type=").append(this.workType).append(", entry=").append(this.indexEntry).append("]");
        return sb.toString();
    }
}

