/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.AbstractLuceneWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneIndexWorkExecutionContext;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneFlushIndexWork
extends AbstractLuceneWork<Void> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public LuceneFlushIndexWork(String indexName) {
        super("flushIndex", indexName);
    }

    @Override
    public CompletableFuture<Void> execute(LuceneIndexWorkExecutionContext context) {
        return Futures.create(() -> CompletableFuture.completedFuture(null).thenRun(() -> this.flushIndex(context.getIndexWriter())));
    }

    private void flushIndex(IndexWriter indexWriter) {
        try {
            indexWriter.flush();
        }
        catch (IOException e) {
            throw log.unableToFlushIndex(this.getEventContext(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("type=").append(this.workType).append(", indexName=").append(this.indexName).append("]");
        return sb.toString();
    }
}

