package org.hibernate.search.backend.lucene.logging.impl;

import java.util.Locale;
import java.nio.file.Path;
import java.io.Serializable;
import org.hibernate.search.engine.backend.index.spi.IndexSearchScopeBuilder;
import org.apache.lucene.search.Query;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import java.io.IOException;
import org.hibernate.search.engine.search.SearchPredicate;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import java.lang.Integer;
import org.apache.lucene.util.Version;
import org.jboss.logging.BasicLogger;
import java.lang.Object;
import java.util.Arrays;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void couldNotCloseResource(final Exception e) {
        super.log.logf(FQCN, WARN, e, couldNotCloseResource$str());
    }
    private static final String couldNotCloseResource = "HSEARCH000035: Could not close resource.";
    protected String couldNotCloseResource$str() {
        return couldNotCloseResource;
    }
    @Override
    public final void unableToCloseIndexReader(final EventContext context, final Exception e) {
        super.log.logf(FQCN, WARN, e, unableToCloseIndexReader$str(), new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context));
    }
    private static final String unableToCloseIndexReader = "HSEARCH000055: Unable to close the index reader. %1$s";
    protected String unableToCloseIndexReader$str() {
        return unableToCloseIndexReader;
    }
    @Override
    public final void recommendConfiguringLuceneVersion(final String key, final Version latest, final EventContext context) {
        super.log.logf(FQCN, WARN, null, recommendConfiguringLuceneVersion$str(), key, latest, new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context));
    }
    private static final String recommendConfiguringLuceneVersion = "HSEARCH000075: Configuration setting '%1$s' was not specified: using LATEST (currently '%2$s'). %3$s";
    protected String recommendConfiguringLuceneVersion$str() {
        return recommendConfiguringLuceneVersion;
    }
    private static final String unableToLoadResource = "HSEARCH000114: Could not load resource: '%1$s'";
    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }
    @Override
    public final SearchException unableToLoadResource(final String fileName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToLoadResource$str(), fileName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalLuceneVersionFormat = "HSEARCH000228: Value '%1$ss' is not in a valid format to express a Lucene version: %2$s";
    protected String illegalLuceneVersionFormat$str() {
        return illegalLuceneVersionFormat;
    }
    @Override
    public final SearchException illegalLuceneVersionFormat(final String property, final String luceneErrorMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), illegalLuceneVersionFormat$str(), property, luceneErrorMessage), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ioExceptionOnMultiReaderRefresh = "HSEARCH000284: An IOException happened while opening multiple indexes.";
    protected String ioExceptionOnMultiReaderRefresh$str() {
        return ioExceptionOnMultiReaderRefresh;
    }
    @Override
    public final SearchException ioExceptionOnMultiReaderRefresh(final EventContext context, final IOException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), ioExceptionOnMultiReaderRefresh$str()), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotNormalizeField = "HSEARCH000320: Could not normalize value for field '%1$s'.";
    protected String couldNotNormalizeField$str() {
        return couldNotNormalizeField;
    }
    @Override
    public final SearchException couldNotNormalizeField(final String absoluteFieldPath, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), couldNotNormalizeField$str(), absoluteFieldPath), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void multipleTermsDetectedDuringNormalization(final String absoluteFieldPath) {
        super.log.logf(FQCN, WARN, null, multipleTermsDetectedDuringNormalization$str(), absoluteFieldPath);
    }
    private static final String multipleTermsDetectedDuringNormalization = "HSEARCH000321: The analysis of field '%1$s' produced multiple tokens. Tokenization or term generation (synonyms) should not be used on sortable fields or range queries. Only the first token will be considered.";
    protected String multipleTermsDetectedDuringNormalization$str() {
        return multipleTermsDetectedDuringNormalization;
    }
    private static final String unableToApplyAnalysisConfiguration = "HSEARCH000329: Error while applying analysis configuration: %1$s";
    protected String unableToApplyAnalysisConfiguration$str() {
        return unableToApplyAnalysisConfiguration;
    }
    @Override
    public final SearchException unableToApplyAnalysisConfiguration(final String errorMessage, final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToApplyAnalysisConfiguration$str(), errorMessage), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String analyzerDefinitionNamingConflict = "HSEARCH000330: Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.";
    protected String analyzerDefinitionNamingConflict$str() {
        return analyzerDefinitionNamingConflict;
    }
    @Override
    public final SearchException analyzerDefinitionNamingConflict(final String analyzerDefinitionName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analyzerDefinitionNamingConflict$str(), analyzerDefinitionName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String analysisComponentParameterConflict = "HSEARCH000337: Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    protected String analysisComponentParameterConflict$str() {
        return analysisComponentParameterConflict;
    }
    @Override
    public final SearchException analysisComponentParameterConflict(final String name, final String value1, final String value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analysisComponentParameterConflict$str(), name, value1, value2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String normalizerDefinitionNamingConflict = "HSEARCH000341: Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.";
    protected String normalizerDefinitionNamingConflict$str() {
        return normalizerDefinitionNamingConflict;
    }
    @Override
    public final SearchException normalizerDefinitionNamingConflict(final String normalizerDefinitionName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), normalizerDefinitionNamingConflict$str(), normalizerDefinitionName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotApplyAnalyzerAndNormalizer = "HSEARCH000342: Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.";
    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return cannotApplyAnalyzerAndNormalizer;
    }
    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(final String analyzerName, final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void normalizerProducedMultipleTokens(final String normalizerName, final int token) {
        super.log.logf(FQCN, WARN, null, normalizerProducedMultipleTokens$str(), normalizerName, token);
    }
    private static final String normalizerProducedMultipleTokens = "HSEARCH000344: The normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.";
    protected String normalizerProducedMultipleTokens$str() {
        return normalizerProducedMultipleTokens;
    }
    private static final String cannotUseAnalyzerOnSortableField = "HSEARCH000345: Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    protected String cannotUseAnalyzerOnSortableField$str() {
        return cannotUseAnalyzerOnSortableField;
    }
    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownAnalyzer = "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    protected String unknownAnalyzer$str() {
        return unknownAnalyzer;
    }
    @Override
    public final SearchException unknownAnalyzer(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownAnalyzer$str(), analyzerName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownFieldForSearch = "HSEARCH600000: Unknown field '%1$s'.";
    protected String unknownFieldForSearch$str() {
        return unknownFieldForSearch;
    }
    @Override
    public final SearchException unknownFieldForSearch(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForSearch$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String localDirectoryBackendRootDirectoryNotWritableDirectory = "HSEARCH600001: Root directory '%1$s' exists but is not a writable directory.";
    protected String localDirectoryBackendRootDirectoryNotWritableDirectory$str() {
        return localDirectoryBackendRootDirectoryNotWritableDirectory;
    }
    @Override
    public final SearchException localDirectoryBackendRootDirectoryNotWritableDirectory(final Path rootDirectory, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), localDirectoryBackendRootDirectoryNotWritableDirectory$str(), rootDirectory), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateRootDirectoryForLocalDirectoryBackend = "HSEARCH600002: Unable to create root directory '%1$s'.";
    protected String unableToCreateRootDirectoryForLocalDirectoryBackend$str() {
        return unableToCreateRootDirectoryForLocalDirectoryBackend;
    }
    @Override
    public final SearchException unableToCreateRootDirectoryForLocalDirectoryBackend(final Path rootDirectory, final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateRootDirectoryForLocalDirectoryBackend$str(), rootDirectory), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String undefinedLuceneDirectoryProvider = "HSEARCH600003: Undefined Lucene directory provider for property '%1$s'.";
    protected String undefinedLuceneDirectoryProvider$str() {
        return undefinedLuceneDirectoryProvider;
    }
    @Override
    public final SearchException undefinedLuceneDirectoryProvider(final String propertyKey, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), undefinedLuceneDirectoryProvider$str(), propertyKey), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unrecognizedLuceneDirectoryProvider = "HSEARCH600004: Unrecognized Lucene directory provider '%1$s'.";
    protected String unrecognizedLuceneDirectoryProvider$str() {
        return unrecognizedLuceneDirectoryProvider;
    }
    @Override
    public final SearchException unrecognizedLuceneDirectoryProvider(final String directoryProvider, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unrecognizedLuceneDirectoryProvider$str(), directoryProvider), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String luceneExtensionOnUnknownType = "HSEARCH600005: The Lucene extension can only be applied to objects derived from the Lucene backend. Was applied to '%1$s' instead.";
    protected String luceneExtensionOnUnknownType$str() {
        return luceneExtensionOnUnknownType;
    }
    @Override
    public final SearchException luceneExtensionOnUnknownType(final Object context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), luceneExtensionOnUnknownType$str(), context));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixLuceneSearchQueryWithOtherPredicates = "HSEARCH600010: A Lucene query cannot include search predicates built using a non-Lucene search scope. Given predicate was: '%1$s'";
    protected String cannotMixLuceneSearchQueryWithOtherPredicates$str() {
        return cannotMixLuceneSearchQueryWithOtherPredicates;
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherPredicates(final SearchPredicate predicate) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherPredicates$str(), predicate));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonObjectFieldForNestedQuery = "HSEARCH600012: Field '%1$s' is not an object field.";
    protected String nonObjectFieldForNestedQuery$str() {
        return nonObjectFieldForNestedQuery;
    }
    @Override
    public final SearchException nonObjectFieldForNestedQuery(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonObjectFieldForNestedQuery$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonNestedFieldForNestedQuery = "HSEARCH600013: Object field '%1$s' is not stored as nested.";
    protected String nonNestedFieldForNestedQuery$str() {
        return nonNestedFieldForNestedQuery;
    }
    @Override
    public final SearchException nonNestedFieldForNestedQuery(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonNestedFieldForNestedQuery$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixLuceneSearchSortWithOtherSorts = "HSEARCH600014: A Lucene query cannot include search sorts built using a non-Lucene search scope. Given sort was: '%1$s'";
    protected String cannotMixLuceneSearchSortWithOtherSorts$str() {
        return cannotMixLuceneSearchSortWithOtherSorts;
    }
    @Override
    public final SearchException cannotMixLuceneSearchSortWithOtherSorts(final SearchSort sort) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchSortWithOtherSorts$str(), sort));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateIndexWriter = "HSEARCH600015: Unable to create the IndexWriter.";
    protected String unableToCreateIndexWriter$str() {
        return unableToCreateIndexWriter;
    }
    @Override
    public final SearchException unableToCreateIndexWriter(final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateIndexWriter$str()), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToIndexEntry = "HSEARCH600016: Unable to index entry '%2$s' with tenant identifier '%1$s'.";
    protected String unableToIndexEntry$str() {
        return unableToIndexEntry;
    }
    @Override
    public final SearchException unableToIndexEntry(final String tenantId, final String id, final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToIndexEntry$str(), tenantId, id), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDeleteEntryFromIndex = "HSEARCH600017: Unable to delete entry '%2$s' with tenant identifier '%1$s'.";
    protected String unableToDeleteEntryFromIndex$str() {
        return unableToDeleteEntryFromIndex;
    }
    @Override
    public final SearchException unableToDeleteEntryFromIndex(final String tenantId, final String id, final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDeleteEntryFromIndex$str(), tenantId, id), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToFlushIndex = "HSEARCH600018: Unable to flush.";
    protected String unableToFlushIndex$str() {
        return unableToFlushIndex;
    }
    @Override
    public final SearchException unableToFlushIndex(final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToFlushIndex$str()), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCommitIndex = "HSEARCH600019: Unable to commit.";
    protected String unableToCommitIndex$str() {
        return unableToCommitIndex;
    }
    @Override
    public final SearchException unableToCommitIndex(final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCommitIndex$str()), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String localDirectoryIndexRootDirectoryNotWritableDirectory = "HSEARCH600020: Index directory '%1$s' exists but is not a writable directory.";
    protected String localDirectoryIndexRootDirectoryNotWritableDirectory$str() {
        return localDirectoryIndexRootDirectoryNotWritableDirectory;
    }
    @Override
    public final SearchException localDirectoryIndexRootDirectoryNotWritableDirectory(final Path indexDirectory, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), localDirectoryIndexRootDirectoryNotWritableDirectory$str(), indexDirectory), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateIndexRootDirectoryForLocalDirectoryBackend = "HSEARCH600021: Unable to create index root directory '%1$s'.";
    protected String unableToCreateIndexRootDirectoryForLocalDirectoryBackend$str() {
        return unableToCreateIndexRootDirectoryForLocalDirectoryBackend;
    }
    @Override
    public final SearchException unableToCreateIndexRootDirectoryForLocalDirectoryBackend(final Path indexDirectory, final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateIndexRootDirectoryForLocalDirectoryBackend$str(), indexDirectory), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateIndexReader = "HSEARCH600022: Could not open an index reader.";
    protected String unableToCreateIndexReader$str() {
        return unableToCreateIndexReader;
    }
    @Override
    public final SearchException unableToCreateIndexReader(final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateIndexReader$str()), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixLuceneSearchScopeWithOtherType = "HSEARCH600024: A search query cannot have a scope spanning both an Lucene index and another type of index. Base scope was: '%1$s', Lucene index was: '%2$s'";
    protected String cannotMixLuceneSearchScopeWithOtherType$str() {
        return cannotMixLuceneSearchScopeWithOtherType;
    }
    @Override
    public final SearchException cannotMixLuceneSearchScopeWithOtherType(final IndexSearchScopeBuilder baseScope, final LuceneIndexManager luceneIndex, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchScopeWithOtherType$str(), baseScope, luceneIndex), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixLuceneSearchScopeWithOtherBackend = "HSEARCH600025: A search query cannot have a scope spanning multiple Lucene backends. Base scope was: '%1$s', index from another backend was: '%2$s'";
    protected String cannotMixLuceneSearchScopeWithOtherBackend$str() {
        return cannotMixLuceneSearchScopeWithOtherBackend;
    }
    @Override
    public final SearchException cannotMixLuceneSearchScopeWithOtherBackend(final IndexSearchScopeBuilder baseScope, final LuceneIndexManager indexFromOtherBackend, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ioExceptionOnQueryExecution = "HSEARCH600027: An IOException happened while executing the query '%1$s'.";
    protected String ioExceptionOnQueryExecution$str() {
        return ioExceptionOnQueryExecution;
    }
    @Override
    public final SearchException ioExceptionOnQueryExecution(final Query luceneQuery, final EventContext context, final IOException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), ioExceptionOnQueryExecution$str(), luceneQuery), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multiTenancyRequiredButNotSupportedByBackend = "HSEARCH600029: Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.";
    protected String multiTenancyRequiredButNotSupportedByBackend$str() {
        return multiTenancyRequiredButNotSupportedByBackend;
    }
    @Override
    public final SearchException multiTenancyRequiredButNotSupportedByBackend(final String indexName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyRequiredButNotSupportedByBackend$str(), indexName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMultiTenancyStrategyName = "HSEARCH600030: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    protected String invalidMultiTenancyStrategyName$str() {
        return invalidMultiTenancyStrategyName;
    }
    @Override
    public final SearchException invalidMultiTenancyStrategyName(final String invalidRepresentation, final java.util.List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tenantIdProvidedButMultiTenancyDisabled = "HSEARCH600031: Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.";
    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return tenantIdProvidedButMultiTenancyDisabled;
    }
    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(final String tenantId, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multiTenancyEnabledButNoTenantIdProvided = "HSEARCH600032: Backend has multi-tenancy enabled, but no tenant identifier is provided.";
    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return multiTenancyEnabledButNoTenantIdProvided;
    }
    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyEnabledButNoTenantIdProvided$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String backendUnwrappingWithUnknownType = "HSEARCH600033: Attempt to unwrap a Lucene backend to '%1$s', but this backend can only be unwrapped to '%2$s'.";
    protected String backendUnwrappingWithUnknownType$str() {
        return backendUnwrappingWithUnknownType;
    }
    @Override
    public final SearchException backendUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), backendUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexSchemaNodeNameConflict = "HSEARCH600034: The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    protected String indexSchemaNodeNameConflict$str() {
        return indexSchemaNodeNameConflict;
    }
    @Override
    public final SearchException indexSchemaNodeNameConflict(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaNodeNameConflict$str(), relativeFieldName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rangePredicatesNotSupportedByGeoPoint = "HSEARCH600037: Range predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    protected String rangePredicatesNotSupportedByGeoPoint$str() {
        return rangePredicatesNotSupportedByGeoPoint;
    }
    @Override
    public final SearchException rangePredicatesNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangePredicatesNotSupportedByGeoPoint$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String matchPredicatesNotSupportedByGeoPoint = "HSEARCH600038: Match predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    protected String matchPredicatesNotSupportedByGeoPoint$str() {
        return matchPredicatesNotSupportedByGeoPoint;
    }
    @Override
    public final SearchException matchPredicatesNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), matchPredicatesNotSupportedByGeoPoint$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFieldForDocumentElement = "HSEARCH600039: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    protected String invalidFieldForDocumentElement$str() {
        return invalidFieldForDocumentElement;
    }
    @Override
    public final SearchException invalidFieldForDocumentElement(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String spatialPredicatesNotSupportedByFieldType = "HSEARCH600040: Spatial predicates are not supported by this field's type.";
    protected String spatialPredicatesNotSupportedByFieldType$str() {
        return spatialPredicatesNotSupportedByFieldType;
    }
    @Override
    public final SearchException spatialPredicatesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), spatialPredicatesNotSupportedByFieldType$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String distanceOperationsNotSupportedByFieldType = "HSEARCH600041: Distance related operations are not supported by this field's type.";
    protected String distanceOperationsNotSupportedByFieldType$str() {
        return distanceOperationsNotSupportedByFieldType;
    }
    @Override
    public final SearchException distanceOperationsNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), distanceOperationsNotSupportedByFieldType$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String traditionalSortNotSupportedByGeoPoint = "HSEARCH600042: Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.";
    protected String traditionalSortNotSupportedByGeoPoint$str() {
        return traditionalSortNotSupportedByGeoPoint;
    }
    @Override
    public final SearchException traditionalSortNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), traditionalSortNotSupportedByGeoPoint$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String descendingOrderNotSupportedByDistanceSort = "HSEARCH600043: Descending order is not supported for distance sort.";
    protected String descendingOrderNotSupportedByDistanceSort$str() {
        return descendingOrderNotSupportedByDistanceSort;
    }
    @Override
    public final SearchException descendingOrderNotSupportedByDistanceSort(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), descendingOrderNotSupportedByDistanceSort$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String minimumShouldMatchMinimumOutOfBounds = "HSEARCH600044: Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.";
    protected String minimumShouldMatchMinimumOutOfBounds$str() {
        return minimumShouldMatchMinimumOutOfBounds;
    }
    @Override
    public final SearchException minimumShouldMatchMinimumOutOfBounds(final int totalShouldClauseNumber, final int minimum) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchMinimumOutOfBounds$str(), totalShouldClauseNumber, minimum));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String minimumShouldMatchConflictingConstraints = "HSEARCH600045: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    protected String minimumShouldMatchConflictingConstraints$str() {
        return minimumShouldMatchConflictingConstraints;
    }
    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(final int ignoreConstraintCeiling) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchConflictingConstraints$str(), ignoreConstraintCeiling));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedDSLPredicates = "HSEARCH600046: Native fields do not support defining predicates with the DSL: use the Lucene extension and a native query.";
    protected String unsupportedDSLPredicates$str() {
        return unsupportedDSLPredicates;
    }
    @Override
    public final SearchException unsupportedDSLPredicates(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedDSLPredicates$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedDSLSorts = "HSEARCH600047: Native fields do not support defining sorts with the DSL: use the Lucene extension and a native sort.";
    protected String unsupportedDSLSorts$str() {
        return unsupportedDSLSorts;
    }
    @Override
    public final SearchException unsupportedDSLSorts(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedDSLSorts$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedProjection = "HSEARCH600048: This native field does not support projection.";
    protected String unsupportedProjection$str() {
        return unsupportedProjection;
    }
    @Override
    public final SearchException unsupportedProjection(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedProjection$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFieldPath = "HSEARCH600049: Invalid field path; expected path '%1$s', got '%2$s'.";
    protected String invalidFieldPath$str() {
        return invalidFieldPath;
    }
    @Override
    public final SearchException invalidFieldPath(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldPath$str(), expectedPath, actualPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConvertDslParameter = "HSEARCH600050: Unable to convert DSL parameter: %1$s";
    protected String cannotConvertDslParameter$str() {
        return cannotConvertDslParameter;
    }
    @Override
    public final SearchException cannotConvertDslParameter(final String errorMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotConvertDslParameter$str(), errorMessage), cause, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexManagerUnwrappingWithUnknownType = "HSEARCH600051: Attempt to unwrap a Lucene index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.";
    protected String indexManagerUnwrappingWithUnknownType$str() {
        return indexManagerUnwrappingWithUnknownType;
    }
    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexManagerUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateAnalyzer = "HSEARCH600052: Unable to create analyzer for name '%1$s'.";
    protected String unableToCreateAnalyzer$str() {
        return unableToCreateAnalyzer;
    }
    @Override
    public final SearchException unableToCreateAnalyzer(final String name, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateAnalyzer$str(), name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateNormalizer = "HSEARCH600053: Unable to create normalizer for name '%1$s'.";
    protected String unableToCreateNormalizer$str() {
        return unableToCreateNormalizer;
    }
    @Override
    public final SearchException unableToCreateNormalizer(final String name, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateNormalizer$str(), name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownNormalizer = "HSEARCH600054: Unknown normalizer: '%1$s'. Make sure you defined this normalizer.";
    protected String unknownNormalizer$str() {
        return unknownNormalizer;
    }
    @Override
    public final SearchException unknownNormalizer(final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownNormalizer$str(), normalizerName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixLuceneSearchQueryWithOtherProjections = "HSEARCH600055: A Lucene query cannot include search projections built using a non-Lucene search scope. Given projection was: '%1$s'";
    protected String cannotMixLuceneSearchQueryWithOtherProjections$str() {
        return cannotMixLuceneSearchQueryWithOtherProjections;
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherProjections(final org.hibernate.search.engine.search.SearchProjection<?> projection) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherProjections$str(), projection));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidProjectionInvalidType = "HSEARCH600056: Invalid type '%2$s' for projection on field '%1$s'.";
    protected String invalidProjectionInvalidType$str() {
        return invalidProjectionInvalidType;
    }
    @Override
    public final SearchException invalidProjectionInvalidType(final String absoluteFieldPath, final Class<?> type, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidProjectionInvalidType$str(), absoluteFieldPath, new org.hibernate.search.util.common.logging.impl.ClassFormatter(type)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedDSLProjections = "HSEARCH600057: This field does not support projections.";
    protected String unsupportedDSLProjections$str() {
        return unsupportedDSLProjections;
    }
    @Override
    public final SearchException unsupportedDSLProjections(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedDSLProjections$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingFieldTypesForPredicate = "HSEARCH600058: Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.";
    protected String conflictingFieldTypesForPredicate$str() {
        return conflictingFieldTypesForPredicate;
    }
    @Override
    public final SearchException conflictingFieldTypesForPredicate(final String absoluteFieldPath, final LuceneFieldPredicateBuilderFactory component1, final LuceneFieldPredicateBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForPredicate$str(), absoluteFieldPath, component1, component2), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingFieldTypesForSort = "HSEARCH600059: Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.";
    protected String conflictingFieldTypesForSort$str() {
        return conflictingFieldTypesForSort;
    }
    @Override
    public final SearchException conflictingFieldTypesForSort(final String absoluteFieldPath, final LuceneFieldSortBuilderFactory component1, final LuceneFieldSortBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForSort$str(), absoluteFieldPath, component1, component2), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingFieldTypesForProjection = "HSEARCH600060: Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.";
    protected String conflictingFieldTypesForProjection$str() {
        return conflictingFieldTypesForProjection;
    }
    @Override
    public final SearchException conflictingFieldTypesForProjection(final String absoluteFieldPath, final LuceneFieldProjectionBuilderFactory component1, final LuceneFieldProjectionBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForProjection$str(), absoluteFieldPath, component1, component2), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToShutdownBackend = "HSEARCH600061: Failed to shut down the Lucene index manager.";
    protected String failedToShutdownBackend$str() {
        return failedToShutdownBackend;
    }
    @Override
    public final SearchException failedToShutdownBackend(final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToShutdownBackend$str()), cause, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotGuessFieldType = "HSEARCH600062: Cannot guess field type for input type: '%1$s'.";
    protected String cannotGuessFieldType$str() {
        return cannotGuessFieldType;
    }
    @Override
    public final SearchException cannotGuessFieldType(final Class<?> inputType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotGuessFieldType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(inputType)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String documentIdNotCollected = "HSEARCH600064: Unexpected index: documentId '%1$s' was not collected.";
    protected String documentIdNotCollected$str() {
        return documentIdNotCollected;
    }
    @Override
    public final SearchException documentIdNotCollected(final Integer documentId) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), documentIdNotCollected$str(), documentId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonProjectableField = "HSEARCH600065: Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.";
    protected String nonProjectableField$str() {
        return nonProjectableField;
    }
    @Override
    public final SearchException nonProjectableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonProjectableField$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsortableField = "HSEARCH600066: Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.";
    protected String unsortableField$str() {
        return unsortableField;
    }
    @Override
    public final SearchException unsortableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsortableField$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDeleteAllEntriesFromIndex = "HSEARCH600067: Unable to delete all entries with tenant identifier '%1$s'.";
    protected String unableToDeleteAllEntriesFromIndex$str() {
        return unableToDeleteAllEntriesFromIndex;
    }
    @Override
    public final SearchException unableToDeleteAllEntriesFromIndex(final String tenantId, final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDeleteAllEntriesFromIndex$str(), tenantId), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingIdentifierTypesForPredicate = "HSEARCH600068: Multiple conflicting types for identifier: '%1$s' vs. '%2$s'.";
    protected String conflictingIdentifierTypesForPredicate$str() {
        return conflictingIdentifierTypesForPredicate;
    }
    @Override
    public final SearchException conflictingIdentifierTypesForPredicate(final org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter<?> component1, final org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter<?> component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingIdentifierTypesForPredicate$str(), component1, component2), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ioExceptionOnExplain = "HSEARCH600069: An IOException occurred while generating an Explanation.";
    protected String ioExceptionOnExplain$str() {
        return ioExceptionOnExplain;
    }
    @Override
    public final SearchException ioExceptionOnExplain(final IOException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), ioExceptionOnExplain$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String textPredicatesNotSupportedByFieldType = "HSEARCH600070: Text predicates (phrase, fuzzy, wildcard, simple query string) are not supported by this field's type.";
    protected String textPredicatesNotSupportedByFieldType$str() {
        return textPredicatesNotSupportedByFieldType;
    }
    @Override
    public final SearchException textPredicatesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), textPredicatesNotSupportedByFieldType$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompleteFieldDefinition = "HSEARCH600071: Incomplete field definition. You must call toReference() to complete the field definition.";
    protected String incompleteFieldDefinition$str() {
        return incompleteFieldDefinition;
    }
    @Override
    public final SearchException incompleteFieldDefinition(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompleteFieldDefinition$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateReferenceMultipleTimes = "HSEARCH600072: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    protected String cannotCreateReferenceMultipleTimes$str() {
        return cannotCreateReferenceMultipleTimes;
    }
    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCreateReferenceMultipleTimes$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUseIndexNullAsAndAnalyzer = "HSEARCH600073: Index-null-as option is not supported on analyzed field. Trying to define the analyzer: '%1$s' together with index null as: '%2$s'.";
    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return cannotUseIndexNullAsAndAnalyzer;
    }
    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(final String analyzerName, final String indexNullAs, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
