/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.hibernate.search.backend.lucene.analysis.impl.HibernateSearchNormalizerCheckingFilter;

final class HibernateSearchNormalizerWrapper
extends AnalyzerWrapper {
    private final String normalizerName;
    private final Analyzer delegate;

    HibernateSearchNormalizerWrapper(String normalizerName, Analyzer delegate) {
        super(delegate.getReuseStrategy());
        this.normalizerName = normalizerName;
        this.delegate = delegate;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.delegate;
    }

    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        HibernateSearchNormalizerCheckingFilter filter = new HibernateSearchNormalizerCheckingFilter(components.getTokenStream(), this.normalizerName);
        return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)filter);
    }

    public String toString() {
        return "HibernateSearchNormalizerWrapper(" + this.delegate.toString() + ", normalizerName=" + this.normalizerName + ")";
    }
}

