/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.LuceneBackend;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.lucene.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexManagerBuilder;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.DirectoryProvider;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneReadWorkOrchestratorImpl;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneReadWorkOrchestratorImplementor;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.backend.spi.BackendStartContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.engine.common.spi.LogErrorHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneBackendImpl
implements BackendImplementor<LuceneRootDocumentBuilder>,
LuceneBackend {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final DirectoryProvider directoryProvider;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final LuceneReadWorkOrchestratorImplementor readOrchestrator;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final EventContext eventContext;
    private final IndexingBackendContext indexingContext;
    private final SearchBackendContext searchContext;

    LuceneBackendImpl(String name, DirectoryProvider directoryProvider, LuceneWorkFactory workFactory, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy) {
        this.name = name;
        this.directoryProvider = directoryProvider;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.readOrchestrator = new LuceneReadWorkOrchestratorImpl("Lucene read work orchestrator for backend " + name);
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.eventContext = EventContexts.fromBackendName((String)name);
        this.indexingContext = new IndexingBackendContext(this.eventContext, directoryProvider, workFactory, multiTenancyStrategy, (ErrorHandler)new LogErrorHandler());
        this.searchContext = new SearchBackendContext(this.eventContext, workFactory, multiTenancyStrategy, this.readOrchestrator, analysisDefinitionRegistry);
    }

    public void start(BackendStartContext context) {
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(LuceneBackend.class)) {
            return (T)this;
        }
        throw log.backendUnwrappingWithUnknownType(clazz, LuceneBackend.class, this.eventContext);
    }

    public Backend toAPI() {
        return this;
    }

    public IndexManagerBuilder<LuceneRootDocumentBuilder> createIndexManagerBuilder(String indexName, boolean multiTenancyEnabled, BackendBuildContext context, ConfigurationPropertySource propertySource) {
        if (multiTenancyEnabled && !this.multiTenancyStrategy.isMultiTenancySupported()) {
            throw log.multiTenancyRequiredButNotSupportedByBackend(indexName, this.eventContext);
        }
        LuceneIndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder = new LuceneIndexSchemaRootNodeBuilder(EventContexts.fromIndexName((String)indexName), this.analysisDefinitionRegistry);
        return new LuceneIndexManagerBuilder(this.indexingContext, this.searchContext, indexName, indexSchemaRootNodeBuilder);
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(LuceneReadWorkOrchestratorImplementor::close, (Object)this.readOrchestrator);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.name + ", " + "directoryProvider=" + this.directoryProvider + "]";
    }
}

