/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexDocumentWorkExecutor;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexWorkExecutor;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexWorkPlan;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessor;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneBatchingWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestratorImplementor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkProcessor;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.index.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.index.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexWorkPlan;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexingBackendContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext eventContext;
    private final DirectoryProvider directoryProvider;
    private final LuceneWorkFactory workFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ErrorHandler errorHandler;

    public IndexingBackendContext(EventContext eventContext, DirectoryProvider directoryProvider, LuceneWorkFactory workFactory, MultiTenancyStrategy multiTenancyStrategy, ErrorHandler errorHandler) {
        this.eventContext = eventContext;
        this.directoryProvider = directoryProvider;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.workFactory = workFactory;
        this.errorHandler = errorHandler;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    EventContext getEventContext() {
        return this.eventContext;
    }

    IndexAccessor createIndexAccessor(String indexName, Analyzer analyzer) {
        Directory directory;
        try {
            directory = this.directoryProvider.createDirectory(indexName);
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToCreateIndexDirectory(this.eventContext.append(EventContexts.fromIndexName((String)indexName)), e);
        }
        try {
            return new IndexAccessor(indexName, directory, analyzer, this.errorHandler);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)directory);
            throw e;
        }
    }

    IndexWorkPlan<LuceneRootDocumentBuilder> createWorkPlan(LuceneWriteWorkOrchestrator orchestrator, String indexName, SessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new LuceneIndexWorkPlan(this.workFactory, this.multiTenancyStrategy, orchestrator, indexName, sessionContext, commitStrategy, refreshStrategy);
    }

    LuceneWriteWorkOrchestratorImplementor createOrchestrator(String indexName, IndexWriterDelegator indexWriterDelegator) {
        return new LuceneBatchingWriteWorkOrchestrator("Lucene write work orchestrator for index " + indexName, new LuceneWriteWorkProcessor(EventContexts.fromIndexName((String)indexName), indexWriterDelegator, this.errorHandler), this.errorHandler);
    }

    IndexDocumentWorkExecutor<LuceneRootDocumentBuilder> createDocumentWorkExecutor(LuceneWriteWorkOrchestrator orchestrator, String indexName, SessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new LuceneIndexDocumentWorkExecutor(this.workFactory, this.multiTenancyStrategy, orchestrator, indexName, sessionContext, commitStrategy);
    }

    IndexWorkExecutor createWorkExecutor(LuceneWriteWorkOrchestrator orchestrator, String indexName) {
        return new LuceneIndexWorkExecutor(this.workFactory, this.multiTenancyStrategy, orchestrator, indexName, this.eventContext);
    }
}

