/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.directory.impl;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.DirectoryHelper;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.DirectoryProvider;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reporting.EventContext;

public class MMapDirectoryProvider
implements DirectoryProvider {
    private final EventContext backendContext;
    private final Path rootDirectory;

    public MMapDirectoryProvider(EventContext backendContext, Path rootDirectory) {
        this.backendContext = backendContext;
        this.rootDirectory = rootDirectory;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[rootDirectory=" + this.rootDirectory + "]";
    }

    @Override
    public Directory createDirectory(String indexName) throws IOException {
        EventContext indexContext = this.backendContext.append(EventContexts.fromIndexName((String)indexName));
        Path directoryPath = this.rootDirectory.resolve(indexName);
        DirectoryHelper.makeSanityCheckedFilesystemDirectory(directoryPath, indexContext);
        MMapDirectory directory = new MMapDirectory(directoryPath);
        try {
            DirectoryHelper.initializeIndexIfNeeded((Directory)directory, indexContext);
        }
        catch (IOException | RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)directory);
            throw e;
        }
        return directory;
    }
}

