/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.reader.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.hibernate.search.backend.lucene.index.spi.ReaderProvider;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ManagedMultiReader
extends MultiReader {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    final ReaderProvider[] readerProviders;

    private ManagedMultiReader(IndexReader[] subReaders, ReaderProvider[] readerProviders) throws IOException {
        super(subReaders, true);
        this.readerProviders = readerProviders;
    }

    static ManagedMultiReader createInstance(Set<ReaderProvider> readerProviders) throws IOException {
        IndexReader[] indexReaders = (IndexReader[])readerProviders.stream().map(ReaderProvider::openIndexReader).toArray(IndexReader[]::new);
        return new ManagedMultiReader(indexReaders, readerProviders.toArray(new ReaderProvider[0]));
    }

    protected synchronized void doClose() {
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debugf("Closing MultiReader: %s", (Object)this);
        }
        for (int i = 0; i < this.getSequentialSubReaders().size(); ++i) {
            ReaderProvider container = this.readerProviders[i];
            container.closeIndexReader((IndexReader)this.getSequentialSubReaders().get(i));
        }
        if (debugEnabled) {
            log.trace("MultiReader closed.");
        }
    }

    public List<? extends IndexReader> getSubReaders() {
        return this.getSequentialSubReaders();
    }

    public String toString() {
        return ManagedMultiReader.class.getSimpleName() + " [subReaders=" + this.getSequentialSubReaders() + ", readerProviders=" + Arrays.toString(this.readerProviders) + "]";
    }
}

