/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.writer.impl;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.HibernateSearchConcurrentMergeScheduler;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexWriterDelegatorImpl
implements Closeable,
IndexWriterDelegator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String indexName;
    private final EventContext indexEventContext;
    private final Directory directory;
    private final Analyzer analyzer;
    private final ErrorHandler errorHandler;
    private final AtomicReference<IndexWriter> writer = new AtomicReference();
    private final ReentrantLock writerInitializationLock = new ReentrantLock();

    public IndexWriterDelegatorImpl(String indexName, Directory directory, Analyzer analyzer, ErrorHandler errorHandler) {
        this.indexName = indexName;
        this.indexEventContext = EventContexts.fromIndexName((String)indexName);
        this.directory = directory;
        this.analyzer = analyzer;
        this.errorHandler = errorHandler;
    }

    @Override
    public void close() throws IOException {
        IndexWriter toClose = this.writer.getAndSet(null);
        if (toClose != null) {
            try {
                toClose.close();
                log.trace("IndexWriter closed");
            }
            catch (IOException ioe) {
                this.forceLockRelease();
                throw ioe;
            }
        }
    }

    @Override
    public long addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        return this.getOrCreateIndexWriter().addDocuments(docs);
    }

    @Override
    public long updateDocuments(Term term, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        return this.getOrCreateIndexWriter().updateDocuments(term, docs);
    }

    @Override
    public long deleteDocuments(Term term) throws IOException {
        return this.getOrCreateIndexWriter().deleteDocuments(new Term[]{term});
    }

    @Override
    public long deleteDocuments(Query query) throws IOException {
        return this.getOrCreateIndexWriter().deleteDocuments(new Query[]{query});
    }

    @Override
    public long deleteAll() throws IOException {
        return this.getOrCreateIndexWriter().deleteAll();
    }

    @Override
    public void commit() throws IOException {
        this.getOrCreateIndexWriter().commit();
    }

    @Override
    public void flush() throws IOException {
        this.getOrCreateIndexWriter().flush();
    }

    @Override
    public void forceMerge() throws IOException {
        this.getOrCreateIndexWriter().forceMerge(1);
    }

    @Override
    public void forceLockRelease() throws IOException {
        log.forcingReleaseIndexWriterLock(this.indexEventContext);
        this.writerInitializationLock.lock();
        try {
            IndexWriter indexWriter = this.writer.getAndSet(null);
            if (indexWriter != null) {
                indexWriter.close();
                log.trace("IndexWriter closed");
            }
        }
        finally {
            this.writerInitializationLock.unlock();
        }
    }

    public IndexWriter getIndexWriterOrNull() {
        return this.writer.get();
    }

    private IndexWriter getOrCreateIndexWriter() throws IOException {
        IndexWriter indexWriter = this.writer.get();
        if (indexWriter == null) {
            this.writerInitializationLock.lock();
            try {
                indexWriter = this.writer.get();
                if (indexWriter == null) {
                    indexWriter = this.createNewIndexWriter();
                    log.trace("IndexWriter opened");
                    this.writer.set(indexWriter);
                }
            }
            finally {
                this.writerInitializationLock.unlock();
            }
        }
        return indexWriter;
    }

    private IndexWriter createNewIndexWriter() throws IOException {
        IndexWriterConfig indexWriterConfig = this.createWriterConfig();
        return new IndexWriter(this.directory, indexWriterConfig);
    }

    private IndexWriterConfig createWriterConfig() {
        IndexWriterConfig writerConfig = new IndexWriterConfig(this.analyzer);
        HibernateSearchConcurrentMergeScheduler mergeScheduler = new HibernateSearchConcurrentMergeScheduler(this.errorHandler, this.indexName);
        writerConfig.setMergeScheduler((MergeScheduler)mergeScheduler);
        writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        return writerConfig;
    }
}

