/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkExecutionContextImpl;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWork;
import org.hibernate.search.engine.backend.index.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.orchestration.spi.BatchingExecutor;
import org.hibernate.search.engine.common.spi.ContextualErrorHandler;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneWriteWorkProcessor
implements BatchingExecutor.WorkProcessor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext indexEventContext;
    private final IndexWriterDelegator indexWriterDelegator;
    private final LuceneWriteWorkExecutionContextImpl context;
    private final ErrorHandler errorHandler;
    private boolean hasUncommittedWorks;
    private Throwable workSetFailure;
    private ContextualErrorHandler workSetContextualErrorHandler;
    private boolean workSetForcesCommit;

    public LuceneWriteWorkProcessor(EventContext indexEventContext, IndexWriterDelegator indexWriterDelegator, ErrorHandler errorHandler) {
        this.indexEventContext = indexEventContext;
        this.indexWriterDelegator = indexWriterDelegator;
        this.context = new LuceneWriteWorkExecutionContextImpl(indexWriterDelegator);
        this.errorHandler = errorHandler;
    }

    public void beginBatch() {
    }

    public CompletableFuture<?> endBatch() {
        try {
            this.commitIfNecessary();
        }
        catch (RuntimeException e) {
            try {
                this.cleanUpAfterError();
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            this.errorHandler.handleException(e.getMessage(), (Throwable)e);
        }
        return CompletableFuture.completedFuture(null);
    }

    void beforeWorkSet(DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.workSetFailure = null;
        this.workSetContextualErrorHandler = null;
        this.workSetForcesCommit = DocumentCommitStrategy.FORCE.equals((Object)commitStrategy) || DocumentRefreshStrategy.FORCE.equals((Object)refreshStrategy);
    }

    <T> T submit(LuceneWriteWork<T> work) {
        if (this.workSetFailure == null) {
            try {
                this.hasUncommittedWorks = true;
                return work.execute(this.context);
            }
            catch (RuntimeException e) {
                this.workSetFailure = e;
                this.getWorkSetContextualErrorHandler().markAsFailed(work.getInfo(), (Throwable)e);
                return null;
            }
        }
        this.getWorkSetContextualErrorHandler().markAsSkipped(work.getInfo());
        return null;
    }

    <T> void afterWorkSet(CompletableFuture<T> future, T resultIfSuccess) {
        if (this.workSetFailure == null && this.workSetForcesCommit) {
            try {
                this.commitIfNecessary();
            }
            catch (RuntimeException e) {
                this.workSetFailure = e;
                this.getWorkSetContextualErrorHandler().addThrowable((Throwable)e);
            }
        }
        if (this.workSetFailure != null) {
            try {
                this.cleanUpAfterError();
            }
            catch (RuntimeException e) {
                this.workSetFailure.addSuppressed(e);
            }
            future.completeExceptionally(this.workSetFailure);
            this.getWorkSetContextualErrorHandler().handle();
        } else {
            future.complete(resultIfSuccess);
        }
    }

    private void commitIfNecessary() {
        if (this.hasUncommittedWorks) {
            try {
                this.hasUncommittedWorks = false;
                this.indexWriterDelegator.commit();
            }
            catch (IOException | RuntimeException e) {
                throw log.unableToCommitIndex(this.indexEventContext, e);
            }
        }
    }

    private void cleanUpAfterError() {
        try {
            this.hasUncommittedWorks = false;
            this.indexWriterDelegator.forceLockRelease();
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToCleanUpAfterError(this.indexEventContext, e);
        }
    }

    private ContextualErrorHandler getWorkSetContextualErrorHandler() {
        if (this.workSetContextualErrorHandler == null) {
            this.workSetContextualErrorHandler = this.errorHandler.createContextualHandler();
        }
        return this.workSetContextualErrorHandler;
    }
}

