/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.dsl.query.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.dsl.predicate.LuceneSearchPredicateFactoryContext;
import org.hibernate.search.backend.lucene.search.dsl.projection.LuceneSearchProjectionFactoryContext;
import org.hibernate.search.backend.lucene.search.dsl.query.LuceneSearchQueryContext;
import org.hibernate.search.backend.lucene.search.dsl.query.LuceneSearchQueryResultContext;
import org.hibernate.search.backend.lucene.search.dsl.query.LuceneSearchQueryResultDefinitionContext;
import org.hibernate.search.backend.lucene.search.dsl.query.impl.LuceneSearchQueryContextImpl;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneIndexSearchScope;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilder;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionTerminalContext;
import org.hibernate.search.engine.search.dsl.query.spi.AbstractSearchQueryResultDefinitionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public class LuceneSearchQueryResultDefinitionContextImpl<R, E>
extends AbstractSearchQueryResultDefinitionContext<LuceneSearchQueryContext<E>, R, E, LuceneSearchProjectionFactoryContext<R, E>, LuceneSearchPredicateFactoryContext, LuceneSearchQueryElementCollector>
implements LuceneSearchQueryResultDefinitionContext<R, E> {
    private final LuceneIndexSearchScope indexSearchScope;
    private final SessionContextImplementor sessionContext;
    private final LoadingContextBuilder<R, E> loadingContextBuilder;

    public LuceneSearchQueryResultDefinitionContextImpl(LuceneIndexSearchScope indexSearchScope, SessionContextImplementor sessionContext, LoadingContextBuilder<R, E> loadingContextBuilder) {
        this.indexSearchScope = indexSearchScope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public LuceneSearchQueryResultContext<E> asEntity() {
        SearchQueryBuilder builder = this.indexSearchScope.getSearchQueryBuilderFactory().asEntity(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public LuceneSearchQueryResultContext<R> asReference() {
        SearchQueryBuilder builder = this.indexSearchScope.getSearchQueryBuilderFactory().asReference(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public <P> LuceneSearchQueryResultContext<P> asProjection(Function<? super LuceneSearchProjectionFactoryContext<R, E>, ? extends SearchProjectionTerminalContext<P>> projectionContributor) {
        LuceneSearchProjectionFactoryContext factoryContext = (LuceneSearchProjectionFactoryContext)this.createDefaultProjectionFactoryContext().extension(LuceneExtension.get());
        SearchProjection projection = projectionContributor.apply(factoryContext).toProjection();
        return this.asProjection(projection);
    }

    @Override
    public <P> LuceneSearchQueryResultContext<P> asProjection(SearchProjection<P> projection) {
        SearchQueryBuilder builder = this.indexSearchScope.getSearchQueryBuilderFactory().asProjection(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder, (SearchProjection)projection);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public LuceneSearchQueryResultContext<List<?>> asProjections(SearchProjection<?> ... projections) {
        SearchQueryBuilder builder = this.indexSearchScope.getSearchQueryBuilderFactory().asProjections(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder, (SearchProjection[])projections);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    public LuceneSearchQueryContext<E> predicate(SearchPredicate predicate) {
        return (LuceneSearchQueryContext)this.asEntity().predicate(predicate);
    }

    public LuceneSearchQueryContext<E> predicate(Function<? super LuceneSearchPredicateFactoryContext, SearchPredicateTerminalContext> predicateContributor) {
        return (LuceneSearchQueryContext)this.asEntity().predicate(predicateContributor);
    }

    protected LuceneIndexSearchScope getIndexSearchScope() {
        return this.indexSearchScope;
    }

    protected SessionContextImplementor getSessionContext() {
        return this.sessionContext;
    }

    protected LoadingContextBuilder<R, E> getLoadingContextBuilder() {
        return this.loadingContextBuilder;
    }

    private <H> LuceneSearchQueryResultContext<H> createSearchQueryContext(LuceneSearchQueryBuilder<H> builder) {
        return new LuceneSearchQueryContextImpl<H>(this.indexSearchScope, builder);
    }
}

