/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.impl;

import java.util.Set;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.index.spi.ReaderProvider;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchScopeModel;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentFieldValueConvertContextImpl;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContextImpl;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;

public final class LuceneSearchContext {
    private final ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext;
    private final ToDocumentFieldValueConvertContext toDocumentFieldValueConvertContext;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final LuceneSearchScopeModel scopeModel;

    public LuceneSearchContext(MappingContextImplementor mappingContext, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy, LuceneSearchScopeModel scopeModel) {
        this.toDocumentIdentifierValueConvertContext = new ToDocumentIdentifierValueConvertContextImpl(mappingContext);
        this.toDocumentFieldValueConvertContext = new ToDocumentFieldValueConvertContextImpl(mappingContext);
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.scopeModel = scopeModel;
    }

    public ToDocumentIdentifierValueConvertContext getToDocumentIdentifierValueConvertContext() {
        return this.toDocumentIdentifierValueConvertContext;
    }

    public ToDocumentFieldValueConvertContext getToDocumentFieldValueConvertContext() {
        return this.toDocumentFieldValueConvertContext;
    }

    public LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry() {
        return this.analysisDefinitionRegistry;
    }

    public Set<String> getIndexNames() {
        return this.scopeModel.getIndexNames();
    }

    public Set<ReaderProvider> getReaderProviders() {
        return this.scopeModel.getReaderProviders();
    }

    public Query decorateLuceneQuery(Query originalLuceneQuery, String tenantId) {
        return this.multiTenancyStrategy.decorateLuceneQuery(originalLuceneQuery, tenantId);
    }
}

