/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.util.common.function.TriFunction;

public class LuceneCompositeTriFunctionProjection<P1, P2, P3, P>
implements LuceneCompositeProjection<Object[], P> {
    private final TriFunction<P1, P2, P3, P> transformer;
    private final LuceneSearchProjection<?, P1> projection1;
    private final LuceneSearchProjection<?, P2> projection2;
    private final LuceneSearchProjection<?, P3> projection3;

    public LuceneCompositeTriFunctionProjection(TriFunction<P1, P2, P3, P> transformer, LuceneSearchProjection<?, P1> projection1, LuceneSearchProjection<?, P2> projection2, LuceneSearchProjection<?, P3> projection3) {
        this.transformer = transformer;
        this.projection1 = projection1;
        this.projection2 = projection2;
        this.projection3 = projection3;
    }

    @Override
    public void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        this.projection1.contributeCollectors(luceneCollectorBuilder);
        this.projection2.contributeCollectors(luceneCollectorBuilder);
        this.projection3.contributeCollectors(luceneCollectorBuilder);
    }

    @Override
    public void contributeFields(LuceneDocumentStoredFieldVisitorBuilder builder) {
        this.projection1.contributeFields(builder);
        this.projection2.contributeFields(builder);
        this.projection3.contributeFields(builder);
    }

    @Override
    public Object[] extract(ProjectionHitMapper<?, ?> projectionHitMapper, LuceneResult luceneResult, SearchProjectionExtractContext context) {
        return new Object[]{this.projection1.extract(projectionHitMapper, luceneResult, context), this.projection2.extract(projectionHitMapper, luceneResult, context), this.projection3.extract(projectionHitMapper, luceneResult, context)};
    }

    @Override
    public P transform(LoadingResult<?> loadingResult, Object[] extractedData, SearchProjectionTransformContext context) {
        return (P)this.transformer.apply(LuceneSearchProjection.transformUnsafe(this.projection1, loadingResult, extractedData[0], context), LuceneSearchProjection.transformUnsafe(this.projection2, loadingResult, extractedData[1], context), LuceneSearchProjection.transformUnsafe(this.projection3, loadingResult, extractedData[2], context));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("projection1=").append(this.projection1).append(", projection2=").append(this.projection2).append(", projection3=").append(this.projection3).append("]");
        return sb.toString();
    }
}

