/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.extraction.impl.DistanceCollector;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class SearchProjectionExtractContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexSearcher indexSearcher;
    private final Query luceneQuery;
    private final Map<DistanceCollectorKey, DistanceCollector> distanceCollectors;

    public SearchProjectionExtractContext(IndexSearcher indexSearcher, Query luceneQuery, Map<DistanceCollectorKey, DistanceCollector> distanceCollectors) {
        this.indexSearcher = indexSearcher;
        this.luceneQuery = luceneQuery;
        this.distanceCollectors = distanceCollectors;
    }

    public Explanation explain(int docId) {
        try {
            return this.indexSearcher.explain(this.luceneQuery, docId);
        }
        catch (IOException e) {
            throw log.ioExceptionOnExplain(e);
        }
    }

    public DistanceCollector getDistanceCollector(String absoluteFieldPath, GeoPoint location) {
        DistanceCollectorKey collectorKey = new DistanceCollectorKey(absoluteFieldPath, location);
        return this.distanceCollectors.get(collectorKey);
    }

    public static class DistanceCollectorKey {
        private final String absoluteFieldPath;
        private final GeoPoint location;

        public DistanceCollectorKey(String absoluteFieldPath, GeoPoint location) {
            this.absoluteFieldPath = absoluteFieldPath;
            this.location = location;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DistanceCollectorKey)) {
                return false;
            }
            DistanceCollectorKey other = (DistanceCollectorKey)obj;
            return Objects.equals(this.absoluteFieldPath, other.absoluteFieldPath) && Objects.equals(this.location, other.location);
        }

        public int hashCode() {
            return Objects.hash(this.absoluteFieldPath, this.location);
        }
    }
}

