/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;
import org.hibernate.search.engine.cfg.spi.NumberScaleConstants;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class LuceneBigIntegerFieldCodec
extends AbstractLuceneNumericFieldCodec<BigInteger, Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final int decimalScale;
    private final BigDecimal minScaledValue;
    private final BigDecimal maxScaledValue;

    public LuceneBigIntegerFieldCodec(boolean projectable, boolean sortable, BigInteger indexNullAsValue, int decimalScale) {
        super(projectable, sortable, indexNullAsValue);
        this.decimalScale = decimalScale;
        this.minScaledValue = new BigDecimal(NumberScaleConstants.MIN_LONG_AS_BIGINTEGER, decimalScale);
        this.maxScaledValue = new BigDecimal(NumberScaleConstants.MAX_LONG_AS_BIGINTEGER, decimalScale);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, BigInteger value, Long encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, value.toString()));
    }

    @Override
    public BigInteger decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        return new BigInteger(field.stringValue());
    }

    @Override
    public Long encode(BigInteger value) {
        BigDecimal decimal = new BigDecimal(value);
        if (this.isTooLarge(decimal)) {
            throw log.scaledNumberTooLarge(value);
        }
        return this.unscale(decimal);
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneNumericDomain.LONG;
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (!super.isCompatibleWith(obj)) {
            return false;
        }
        LuceneBigIntegerFieldCodec other = (LuceneBigIntegerFieldCodec)obj;
        return this.decimalScale == other.decimalScale;
    }

    private Long unscale(BigDecimal decimal) {
        return decimal.setScale(this.decimalScale, RoundingMode.HALF_UP).unscaledValue().longValue();
    }

    private boolean isTooLarge(BigDecimal decimal) {
        return decimal.compareTo(this.minScaledValue) < 0 || decimal.compareTo(this.maxScaledValue) > 0;
    }
}

